/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.ConcurrentDownloadTimeoutEvent;
import com.flowingcode.vaadin.addons.gridexporter.ConcurrentStreamResourceWriter;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class GridExporterConcurrentSettings {
    private static long concurrentDownloadTimeoutNanos = 0L;
    private static final List<SerializableConsumer<ConcurrentDownloadTimeoutEvent>> globalDownloadTimeoutListeners = new CopyOnWriteArrayList<SerializableConsumer<ConcurrentDownloadTimeoutEvent>>();

    static List<SerializableConsumer<ConcurrentDownloadTimeoutEvent>> getGlobalDownloadTimeoutListeners() {
        return Collections.unmodifiableList(globalDownloadTimeoutListeners);
    }

    public static void setConcurrentDownloadLimit(float limit) {
        ConcurrentStreamResourceWriter.setLimit(limit);
    }

    public static float getConcurrentDownloadLimit() {
        return ConcurrentStreamResourceWriter.getLimit();
    }

    public static void setFailOnUiChange(boolean failOnUiChange) {
        ConcurrentStreamResourceWriter.setFailOnUiChange(failOnUiChange);
    }

    public static void setConcurrentDownloadTimeout(long timeout, TimeUnit unit) {
        concurrentDownloadTimeoutNanos = unit.toNanos(timeout);
    }

    public static long getConcurrentDownloadTimeout(TimeUnit unit) {
        return unit.convert(concurrentDownloadTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public static Registration addGlobalConcurrentDownloadTimeoutEvent(SerializableConsumer<ConcurrentDownloadTimeoutEvent> listener) {
        globalDownloadTimeoutListeners.add(0, listener);
        return (Registration & Serializable)() -> globalDownloadTimeoutListeners.remove(listener);
    }
}

