/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.grid.dataview.GridLazyDataView;
import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.StreamResourceWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseStreamResourceWriter<T>
implements StreamResourceWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStreamResourceWriter.class);
    protected final GridExporter<T> exporter;
    private String template;

    public BaseStreamResourceWriter(GridExporter<T> exporter) {
        this.exporter = exporter;
    }

    public BaseStreamResourceWriter(GridExporter<T> exporter, String customTemplate, String defaultTemplate) {
        this.exporter = exporter;
        this.template = customTemplate == null ? defaultTemplate : customTemplate;
    }

    protected String getTemplate() {
        return this.template;
    }

    protected boolean isExportable(Grid.Column<T> column) {
        Boolean exported = (Boolean)ComponentUtil.getData(column, (String)"column-value-exported-data");
        return exported != null ? exported.booleanValue() : column.isVisible();
    }

    protected Stream<T> getDataStream(Query newQuery) {
        Stream stream = this.exporter.getGrid().getDataProvider().fetch(newQuery);
        if (stream.isParallel()) {
            LoggerFactory.getLogger(DataCommunicator.class).debug("Data provider {} has returned parallel stream on 'fetch' call", this.exporter.getGrid().getDataProvider().getClass());
            stream = stream.collect(Collectors.toList()).stream();
            assert (!stream.isParallel());
        }
        return stream;
    }

    protected List<Pair<List<String>, Grid.Column<T>>> getGridHeaders(Grid<T> grid) {
        return this.exporter.getColumnsOrdered().stream().map(column -> ImmutablePair.of(this.getHeaderTexts(grid, (Grid.Column<T>)column), (Object)column)).collect(Collectors.toList());
    }

    private List<String> getHeaderTexts(Grid<T> grid, Grid.Column<T> column) {
        ArrayList<String> headerTexts = new ArrayList<String>();
        List headerRows = grid.getHeaderRows();
        for (HeaderRow headerRow : headerRows) {
            String headerText = this.renderCellTextContent(grid, column, "column-header", (SerializableFunction & Serializable)col -> {
                Component component;
                String value = ((HeaderRow.HeaderCell)headerRow.getCell(col)).getText();
                if (Strings.isBlank((String)value) && (component = ((HeaderRow.HeaderCell)headerRow.getCell(col)).getComponent()) != null) {
                    value = component.getElement().getTextRecursively();
                }
                return value;
            });
            headerTexts.add(headerText);
        }
        return headerTexts;
    }

    protected List<Pair<String, Grid.Column<T>>> getGridFooters(Grid<T> grid) {
        return this.exporter.getColumnsOrdered().stream().map(column -> ImmutablePair.of((Object)this.renderCellTextContent(grid, (Grid.Column<T>)column, "column-footer", null), (Object)column)).collect(Collectors.toList());
    }

    private String renderCellTextContent(Grid<T> grid, Grid.Column<T> column, String columnType, SerializableFunction<Grid.Column<T>, String> obtainCellFunction) {
        String headerOrFooter = (String)ComponentUtil.getData(column, (String)columnType);
        if (Strings.isBlank((String)headerOrFooter)) {
            SerializableFunction & Serializable getHeaderOrFooterComponent;
            if ("column-header".equals(columnType)) {
                getHeaderOrFooterComponent = (SerializableFunction & Serializable)rec$ -> ((Grid.Column)rec$).getHeaderComponent();
                headerOrFooter = column.getHeaderText();
            } else if ("column-footer".equals(columnType)) {
                getHeaderOrFooterComponent = (SerializableFunction & Serializable)rec$ -> ((Grid.Column)rec$).getFooterComponent();
                headerOrFooter = column.getFooterText();
            } else {
                throw new IllegalArgumentException();
            }
            if (Strings.isBlank((String)headerOrFooter)) {
                try {
                    if (obtainCellFunction != null) {
                        headerOrFooter = (String)obtainCellFunction.apply(column);
                    } else {
                        Component component = (Component)getHeaderOrFooterComponent.apply(column);
                        if (component != null) {
                            headerOrFooter = component.getElement().getTextRecursively();
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Problem when trying to render header or footer cell text content", e);
                }
            }
        }
        return headerOrFooter;
    }

    protected Stream<T> obtainDataStream(DataProvider<T, ?> dataProvider) {
        Stream<T> dataStream;
        Grid<T> grid = this.exporter.getGrid();
        Object filter = null;
        try {
            Method method = DataCommunicator.class.getDeclaredMethod("getFilter", new Class[0]);
            method.setAccessible(true);
            filter = method.invoke((Object)grid.getDataCommunicator(), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get filter from DataCommunicator", (Throwable)e);
        }
        if (grid.getDataProvider() instanceof HierarchicalDataProvider) {
            return this.obtainFlattenedHierarchicalDataStream(grid);
        }
        if (dataProvider instanceof AbstractBackEndDataProvider) {
            GridLazyDataView gridLazyDataView = grid.getLazyDataView();
            dataStream = gridLazyDataView.getItems();
        } else {
            Query streamQuery = new Query(0, grid.getDataProvider().size(new Query(filter)), grid.getDataCommunicator().getBackEndSorting(), (Comparator)grid.getDataCommunicator().getInMemorySorting(), filter);
            dataStream = this.getDataStream(streamQuery);
        }
        return dataStream;
    }

    private Stream<T> obtainFlattenedHierarchicalDataStream(Grid<T> grid) {
        ArrayList<Object> flattenedData = this.fetchDataRecursive(grid, null);
        return flattenedData.stream();
    }

    private ArrayList<T> fetchDataRecursive(Grid<T> grid, T parent) {
        HierarchicalDataProvider hDataProvider;
        int childCount;
        ArrayList<T> result = new ArrayList<T>();
        if (parent != null) {
            result.add(parent);
        }
        if ((childCount = (hDataProvider = (HierarchicalDataProvider)grid.getDataProvider()).getChildCount(new HierarchicalQuery(0, Integer.MAX_VALUE, grid.getSortOrder().stream().flatMap(so -> so.getSorted().getSortOrder(so.getDirection())).collect(Collectors.toList()), (Comparator)grid.getDataCommunicator().getInMemorySorting(), null, parent))) > 0) {
            hDataProvider.fetchChildren(new HierarchicalQuery(0, Integer.MAX_VALUE, grid.getSortOrder().stream().flatMap(so -> so.getSorted().getSortOrder(so.getDirection())).collect(Collectors.toList()), (Comparator)grid.getDataCommunicator().getInMemorySorting(), null, parent)).forEach(child -> {
                ArrayList<Object> subTree = this.fetchDataRecursive(grid, child);
                result.addAll(subTree);
            });
        }
        return result;
    }
}

