/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.BaseStreamResourceWriter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.opencsv.CSVWriter;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CsvStreamResourceWriter<T>
extends BaseStreamResourceWriter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvStreamResourceWriter.class);

    public CsvStreamResourceWriter(GridExporter<T> exporter) {
        super(exporter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(OutputStream out, VaadinSession session) throws IOException {
        String[] footers;
        List data;
        String[] headers;
        session.lock();
        try {
            this.exporter.setColumns(this.exporter.grid.getColumns().stream().filter(this::isExportable).collect(Collectors.toList()));
            headers = (String[])this.getGridHeaders(this.exporter.grid).stream().map(Pair::getLeft).toArray(String[]::new);
            data = this.obtainDataStream(this.exporter.grid.getDataProvider()).map(this::buildRow).collect(Collectors.toList());
            footers = (String[])this.getGridFooters(this.exporter.grid).stream().filter(pair -> StringUtils.isNotBlank((CharSequence)((CharSequence)pair.getKey()))).map(Pair::getLeft).toArray(String[]::new);
        }
        finally {
            session.unlock();
        }
        try (OutputStreamWriter os = new OutputStreamWriter(out, this.exporter.getCsvCharset());
             CSVWriter writer = new CSVWriter((Writer)os);){
            if (StandardCharsets.UTF_8.equals(this.exporter.getCsvCharset())) {
                os.write(65279);
            }
            writer.writeNext(headers);
            writer.writeAll(data);
            if (footers.length > 0) {
                writer.writeNext(footers);
            }
        }
    }

    private String[] buildRow(T item) {
        if (this.exporter.propertySet == null) {
            this.exporter.propertySet = BeanPropertySet.get(item.getClass());
        }
        if (this.exporter.getColumns().isEmpty()) {
            throw new IllegalStateException("Grid has no columns");
        }
        String[] result = new String[this.exporter.getColumns().size()];
        int[] currentColumn = new int[1];
        this.exporter.getColumnsOrdered().stream().forEach(column -> {
            Object value = this.exporter.extractValueFromColumn(item, column);
            result[currentColumn[0]] = "" + value;
            currentColumn[0] = currentColumn[0] + 1;
        });
        return result;
    }
}

