/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.vaadin.flow.server.StreamResourceWriter;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;

abstract class ConcurrentStreamResourceWriter
implements StreamResourceWriter {
    public static final float MAX_COST = 32767.0f;
    public static final float MIN_COST = 1.5258789E-5f;
    public static final float DEFAULT_COST = 1.0f;
    private static final ConfigurableSemaphore semaphore = new ConfigurableSemaphore();
    private static volatile boolean enabled;
    private final StreamResourceWriter delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLimit(float limit) {
        if (limit <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (Float.isInfinite(limit)) {
            enabled = false;
            return;
        }
        ConfigurableSemaphore configurableSemaphore = semaphore;
        synchronized (configurableSemaphore) {
            enabled = true;
            semaphore.setPermits(ConcurrentStreamResourceWriter.costToPermits(limit, Integer.MAX_VALUE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getLimit() {
        if (enabled) {
            ConfigurableSemaphore configurableSemaphore = semaphore;
            synchronized (configurableSemaphore) {
                return (float)ConcurrentStreamResourceWriter.semaphore.maxPermits / 65536.0f;
            }
        }
        return Float.POSITIVE_INFINITY;
    }

    private static int costToPermits(float cost, int maxPermits) {
        return (cost = Math.min(cost, 32767.0f)) <= 0.0f ? 0 : Math.max(Math.min((int)(cost * 65536.0f), maxPermits), 1);
    }

    ConcurrentStreamResourceWriter(StreamResourceWriter delegate) {
        this.delegate = delegate;
    }

    public abstract long getTimeout();

    public float getCost(VaadinSession session) {
        return 1.0f;
    }

    protected abstract void onTimeout();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void accept(OutputStream stream, VaadinSession session) throws IOException {
        block11: {
            if (!enabled) {
                this.delegate.accept(stream, session);
            } else {
                try {
                    int permits;
                    float cost = this.getCost(session);
                    ConfigurableSemaphore configurableSemaphore = semaphore;
                    synchronized (configurableSemaphore) {
                        permits = ConcurrentStreamResourceWriter.costToPermits(cost, ConcurrentStreamResourceWriter.semaphore.maxPermits);
                    }
                    if (semaphore.tryAcquire(permits, this.getTimeout(), TimeUnit.NANOSECONDS)) {
                        try {
                            this.delegate.accept(stream, session);
                            break block11;
                        }
                        finally {
                            semaphore.release(permits);
                        }
                    }
                    this.onTimeout();
                    throw new InterruptedByTimeoutException();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
        }
    }

    private static final class ConfigurableSemaphore
    extends Semaphore {
        private int maxPermits;

        ConfigurableSemaphore() {
            super(0);
        }

        synchronized void setPermits(int permits) {
            if (permits < 0) {
                throw new IllegalArgumentException();
            }
            int delta = permits - this.maxPermits;
            if (delta > 0) {
                super.release(delta);
            } else if (delta < 0) {
                super.reducePermits(-delta);
            }
            this.maxPermits = permits;
        }

        @Override
        public String toString() {
            IntFunction<String> str = permits -> {
                float f = (float)permits / 65536.0f;
                return (double)f == Math.floor(f) ? String.format("%.0f", Float.valueOf(f)) : Float.toString(f);
            };
            return "Semaphore[" + str.apply(this.availablePermits()) + "/" + str.apply(this.maxPermits) + "]";
        }
    }
}

