/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridexporter.FakerInstance;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.flowingcode.vaadin.addons.gridexporter.PersonTreeEntry;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.EncryptedDocumentException;

@DemoSource
@PageTitle(value="Grid Exporter Hierarchical Data Demo")
@Route(value="gridexporter/hierarchical", layout=GridExporterDemoView.class)
public class GridExporterHierarchicalDataDemo
extends Div {
    private static final Faker faker = FakerInstance.get();
    private Map<Integer, PersonTreeEntry> ageToTreeEntryMap = new HashMap<Integer, PersonTreeEntry>();
    private List<PersonTreeEntry> people;

    public GridExporterHierarchicalDataDemo() throws EncryptedDocumentException, IOException {
        TreeGrid grid = new TreeGrid(PersonTreeEntry.class);
        grid.removeAllColumns();
        grid.setColumnReorderingAllowed(true);
        Grid.Column groupCol = grid.addHierarchyColumn((ValueProvider & Serializable)item -> item.getAge() != null ? item.getAge() : "").setHeader("Group");
        Grid.Column nameCol = grid.addColumn((ValueProvider & Serializable)item -> item.hasPerson() ? item.getPerson().getName() : null).setHeader("Name");
        Grid.Column lastNameCol = grid.addColumn((ValueProvider & Serializable)item -> item.hasPerson() ? item.getPerson().getLastName() : null).setHeader("Last Name");
        Grid.Column ageCol = grid.addColumn((ValueProvider & Serializable)item -> item.hasPerson() ? item.getPerson().getAge() : null).setHeader("Age");
        Grid.Column budgetCol = grid.addColumn((ValueProvider & Serializable)item -> item.hasPerson() ? "$" + item.getPerson().getBudget() : null).setHeader("Budget");
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
        this.people = IntStream.range(0, 100).asLongStream().mapToObj(number -> {
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            total[0] = total[0].add(BigDecimal.valueOf(budget));
            budgetCol.setFooter("$" + total[0]);
            Person p = new Person(faker.name().firstName(), faker.name().lastName(), faker.number().numberBetween(15, 50), budget);
            if (!this.ageToTreeEntryMap.containsKey(p.getAge())) {
                this.ageToTreeEntryMap.put(p.getAge(), new PersonTreeEntry(p.getAge()));
            }
            return new PersonTreeEntry(p);
        }).collect(Collectors.toList());
        grid.setItems(this.ageToTreeEntryMap.values().stream(), (ValueProvider & Serializable)parent -> parent.isRoot() ? this.people.stream().filter(entry -> entry.getPerson().getAge().equals(parent.getAge())) : Stream.empty());
        grid.setWidthFull();
        this.setSizeFull();
        GridExporter exporter = GridExporter.createFor((Grid)grid);
        exporter.setExportValue(budgetCol, (ValueProvider & Serializable)item -> item.hasPerson() ? "" + item.getPerson().getBudget() : "");
        exporter.setTitle("People information grouped by age");
        exporter.setFileName("GridExport" + new SimpleDateFormat("yyyyddMM").format(Calendar.getInstance().getTime()));
        exporter.setAutoSizeColumns(false);
        this.add(new Component[]{grid});
    }
}

