/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridexporter.FakerInstance;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.EncryptedDocumentException;

@DemoSource
@PageTitle(value="Grid Exporter Addon Custom Templates Demo")
@Route(value="gridexporter/custom", layout=GridExporterDemoView.class)
public class GridExporterCustomTemplateDemo
extends Div {
    private static final Faker faker = FakerInstance.get();

    public GridExporterCustomTemplateDemo() throws EncryptedDocumentException, IOException {
        Grid grid = new Grid(Person.class);
        DecimalFormat decimalFormat = new DecimalFormat("$#,###.##");
        grid.removeAllColumns();
        grid.addColumn((Renderer)LitRenderer.of((String)"<b>${item.name}</b>").withProperty("name", Person::getName)).setHeader("Name");
        grid.addColumn("lastName").setHeader("Last Name");
        grid.addColumn((ValueProvider & Serializable)item -> faker.lorem().characters(30, 50)).setHeader("Big column");
        Grid.Column budgetColumn = (Grid.Column)grid.addColumn((ValueProvider & Serializable)item -> decimalFormat.format(item.getBudget())).setHeader("Budget").setTextAlign(ColumnTextAlign.END);
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
        Stream<Person> stream = IntStream.range(0, 100).asLongStream().mapToObj(number -> {
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            total[0] = total[0].add(BigDecimal.valueOf(budget));
            budgetColumn.setFooter(new DecimalFormat("$#,###.##").format(total[0]));
            return new Person(faker.name().firstName(), Math.random() > 0.3 ? faker.name().lastName() : null, faker.number().numberBetween(15, 50), budget);
        });
        grid.setItems(DataProvider.fromStream(stream));
        grid.setWidthFull();
        this.setSizeFull();
        GridExporter exporter = GridExporter.createFor((Grid)grid, (String)"/custom-template.xlsx", (String)"/custom-template.docx");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("${date}", new SimpleDateFormat().format(Calendar.getInstance().getTime()));
        exporter.setAdditionalPlaceHolders(placeholders);
        exporter.setSheetNumber(1);
        exporter.setCsvExportEnabled(false);
        exporter.setAutoSizeColumns(false);
        exporter.setNumberColumnFormat(budgetColumn, decimalFormat, "$#,###.##");
        exporter.setTitle("People information");
        exporter.setNullValueHandler((SerializableSupplier & Serializable)() -> "(No lastname)");
        exporter.setFileName("GridExport" + new SimpleDateFormat("yyyyddMM").format(Calendar.getInstance().getTime()));
        this.add(new Component[]{grid});
    }
}

