/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridexporter.FakerInstance;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.EncryptedDocumentException;

@DemoSource
@PageTitle(value="Grid Exporter Addon Big Dataset Demo")
@Route(value="gridexporter/bigdataset", layout=GridExporterDemoView.class)
public class GridExporterBigDatasetDemo
extends Div {
    private static final Faker faker = FakerInstance.get();

    public GridExporterBigDatasetDemo() throws EncryptedDocumentException, IOException {
        Grid grid = new Grid(Person.class);
        grid.removeAllColumns();
        grid.setColumnReorderingAllowed(true);
        Grid.Column nameCol = grid.addColumn("name").setHeader("Name");
        Grid.Column lastNameCol = grid.addColumn("lastName").setHeader("Last Name");
        Grid.Column budgetCol = grid.addColumn((ValueProvider & Serializable)item -> "$" + item.getBudget()).setHeader("Budget");
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
        List persons = IntStream.range(0, 1400).asLongStream().mapToObj(number -> {
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            total[0] = total[0].add(BigDecimal.valueOf(budget));
            budgetCol.setFooter("$" + total[0]);
            return new Person(faker.name().firstName(), faker.name().lastName(), faker.number().numberBetween(15, 50), budget);
        }).collect(Collectors.toList());
        grid.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> persons.stream().skip(query.getOffset()).limit(query.getLimit()));
        grid.setWidthFull();
        this.setSizeFull();
        GridExporter exporter = GridExporter.createFor((Grid)grid);
        exporter.setAutoSizeColumns(false);
        exporter.setExportValue(budgetCol, (ValueProvider & Serializable)item -> "" + item.getBudget());
        exporter.setColumnPosition(lastNameCol, 1);
        exporter.setTitle("People information");
        exporter.setFileName("GridExport" + new SimpleDateFormat("yyyyddMM").format(Calendar.getInstance().getTime()));
        this.add(new Component[]{grid});
    }
}

