/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.fontawesome.FontAwesome;
import com.flowingcode.vaadin.addons.gridexporter.FakerInstance;
import com.flowingcode.vaadin.addons.gridexporter.FooterToolbarItem;
import com.flowingcode.vaadin.addons.gridexporter.FooterToolbarItemPosition;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.EncryptedDocumentException;

@DemoSource
@PageTitle(value="Grid Exporter Addon Basic Demo")
@Route(value="gridexporter/basic", layout=GridExporterDemoView.class)
public class GridExporterDemo
extends Div {
    private static final Faker faker = FakerInstance.get();

    public GridExporterDemo() throws EncryptedDocumentException, IOException {
        Grid grid = new Grid(Person.class);
        grid.removeAllColumns();
        grid.setColumnReorderingAllowed(true);
        Grid.Column nameCol = grid.addColumn("name").setHeader("Name");
        nameCol.setTextAlign(ColumnTextAlign.START);
        Grid.Column lastNameCol = grid.addColumn("lastName").setHeader("Last Name");
        lastNameCol.setTextAlign(ColumnTextAlign.START);
        Grid.Column budgetCol = grid.addColumn((ValueProvider & Serializable)item -> "$" + item.getBudget()).setHeader("Budget");
        budgetCol.setTextAlign(ColumnTextAlign.END);
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
        Stream<Person> stream = IntStream.range(0, 100).asLongStream().mapToObj(number -> {
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            total[0] = total[0].add(BigDecimal.valueOf(budget));
            budgetCol.setFooter("$" + total[0]);
            return new Person(faker.name().firstName(), faker.name().lastName(), faker.number().numberBetween(15, 50), budget);
        });
        grid.setItems(DataProvider.fromStream(stream));
        grid.setWidthFull();
        this.setSizeFull();
        GridExporter exporter = GridExporter.createFor((Grid)grid);
        exporter.setExportValue(budgetCol, (ValueProvider & Serializable)item -> "" + item.getBudget());
        exporter.setColumnPosition(lastNameCol, 1);
        exporter.setAutoSizeColumns(false);
        exporter.setTitle("People information");
        exporter.setFileName("GridExport" + new SimpleDateFormat("yyyyddMM").format(Calendar.getInstance().getTime()));
        exporter.setCsvCharset((SerializableSupplier & Serializable)() -> StandardCharsets.UTF_8);
        TextField filterField = new TextField();
        filterField.setPlaceholder("Filter by");
        filterField.setWidth("120px");
        Select shareSelect = new Select();
        shareSelect.setItems((Object[])new String[]{"Whatsapp", "Facebook", "X (Twitter)"});
        shareSelect.setWidth("120px");
        Anchor zipLink = new Anchor("", new Component[]{FontAwesome.Regular.FILE_ZIPPER.create()});
        zipLink.setTitle("Download zip file");
        zipLink.getElement().setAttribute("download", true);
        exporter.setFooterToolbarItems(List.of(new FooterToolbarItem((Component)zipLink, FooterToolbarItemPosition.EXPORT_BUTTON), new FooterToolbarItem((Component)new Button("Share", (Component)VaadinIcon.SHARE.create())), new FooterToolbarItem((Component)shareSelect), new FooterToolbarItem((Component)filterField, FooterToolbarItemPosition.BEFORE_EXPORT_BUTTONS), new FooterToolbarItem((Component)new Button("Filter"), FooterToolbarItemPosition.BEFORE_EXPORT_BUTTONS)));
        this.add(new Component[]{grid});
    }
}

