/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.BaseInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.PoiHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.function.ValueProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExcelInputStreamFactory<T>
extends BaseInputStreamFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelInputStreamFactory.class);
    private static final String DEFAULT_TEMPLATE = "/template.xlsx";
    private static final String COLUMN_CELLSTYLE_MAP = "colum-cellstyle-map";

    public ExcelInputStreamFactory(GridExporter<T> exporter, String template) {
        super(exporter, template, DEFAULT_TEMPLATE);
    }

    public InputStream createInputStream() {
        PipedInputStream in = new PipedInputStream();
        try {
            this.exporter.setColumns(this.exporter.grid.getColumns().stream().filter(this::isExportable).peek(col -> ComponentUtil.setData((Component)col, (String)COLUMN_CELLSTYLE_MAP, null)).collect(Collectors.toList()));
            final Workbook wb = this.getBaseTemplateWorkbook();
            Sheet sheet = wb.getSheetAt(this.exporter.sheetNumber);
            Cell titleCell = this.findCellWithPlaceHolder(sheet, this.exporter.titlePlaceHolder);
            if (titleCell != null) {
                titleCell.setCellValue(this.exporter.title);
            }
            Cell cell = this.findCellWithPlaceHolder(sheet, this.exporter.headersPlaceHolder);
            List headers = this.getGridHeaders(this.exporter.grid);
            this.fillHeaderOrFooter(sheet, cell, headers, true);
            if (this.exporter.autoMergeTitle && titleCell != null) {
                sheet.addMergedRegion(new CellRangeAddress(titleCell.getRowIndex(), titleCell.getRowIndex(), titleCell.getColumnIndex(), titleCell.getColumnIndex() + headers.size() - 1));
            }
            cell = this.findCellWithPlaceHolder(sheet, this.exporter.dataPlaceHolder);
            int[] dataStartingColumn = new int[]{cell.getColumnIndex()};
            CellRangeAddress dataRange = new CellRangeAddress(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex());
            Sheet tempSheet = wb.cloneSheet(this.exporter.sheetNumber);
            int lastRow = this.fillData(sheet, cell, this.exporter.grid.getDataProvider(), dataRange, titleCell != null);
            this.applyConditionalFormattings(sheet, dataRange);
            this.copyBottomOfSheetStartingOnRow(wb, tempSheet, sheet, cell.getRowIndex() + 1, lastRow);
            wb.removeSheetAt(this.exporter.sheetNumber + 1);
            cell = this.findCellWithPlaceHolder(sheet, this.exporter.footersPlaceHolder);
            List footers = this.getGridFooters(this.exporter.grid);
            if (cell != null) {
                this.fillHeaderOrFooter(sheet, cell, footers, false);
            }
            if (this.exporter.isAutoSizeColumns()) {
                this.exporter.getColumns().forEach(column -> {
                    sheet.autoSizeColumn(dataStartingColumn[0]);
                    dataStartingColumn[0] = dataStartingColumn[0] + 1;
                });
            }
            this.exporter.additionalPlaceHolders.entrySet().forEach(entry -> {
                Cell cellwp = this.findCellWithPlaceHolder(sheet, (String)entry.getKey());
                while (cellwp != null) {
                    cellwp.setCellValue((String)entry.getValue());
                    cellwp = this.findCellWithPlaceHolder(sheet, (String)entry.getKey());
                }
            });
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        wb.write((OutputStream)out);
                    }
                    catch (IOException e) {
                        LOGGER.error("Problem generating export", (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                LOGGER.error("Problem generating export", (Throwable)e);
                            }
                        }
                    }
                }
            }).start();
        }
        catch (IOException e) {
            LOGGER.error("Problem generating export", (Throwable)e);
        }
        return in;
    }

    private void copyBottomOfSheetStartingOnRow(Workbook workbook, Sheet sourceSheet, Sheet targetSheet, int rowIndex, int targetRow) {
        int fRow = rowIndex;
        int lRow = sourceSheet.getLastRowNum();
        for (int iRow = fRow; iRow <= lRow; ++iRow) {
            Row row = sourceSheet.getRow(iRow);
            Row myRow = targetSheet.createRow(targetRow++);
            if (row == null) continue;
            int fCell = row.getFirstCellNum();
            short lCell = row.getLastCellNum();
            block9: for (int iCell = fCell; iCell < lCell; ++iCell) {
                Cell cell = row.getCell(iCell);
                Cell newCell = myRow.createCell(iCell);
                newCell.setCellStyle(cell.getCellStyle());
                if (cell == null) continue;
                switch (cell.getCellType()) {
                    case BLANK: {
                        newCell.setCellValue("");
                        continue block9;
                    }
                    case BOOLEAN: {
                        newCell.setCellValue(cell.getBooleanCellValue());
                        continue block9;
                    }
                    case ERROR: {
                        newCell.setCellErrorValue(cell.getErrorCellValue());
                        continue block9;
                    }
                    case FORMULA: {
                        newCell.setCellFormula(cell.getCellFormula());
                        continue block9;
                    }
                    case NUMERIC: {
                        newCell.setCellValue(cell.getNumericCellValue());
                        continue block9;
                    }
                    case STRING: {
                        newCell.setCellValue(cell.getStringCellValue());
                        continue block9;
                    }
                    default: {
                        newCell.setCellFormula(cell.getCellFormula());
                    }
                }
            }
        }
    }

    private void applyConditionalFormattings(Sheet sheet, CellRangeAddress targetCellRange) {
        SheetConditionalFormatting sheetCondFormatting = sheet.getSheetConditionalFormatting();
        for (int i = 0; i < sheetCondFormatting.getNumConditionalFormattings(); ++i) {
            ConditionalFormatting condFormatting = sheetCondFormatting.getConditionalFormattingAt(i);
            condFormatting.setFormattingRanges((CellRangeAddress[])ArrayUtils.toArray((Object[])new CellRangeAddress[]{targetCellRange}));
        }
    }

    private int fillData(Sheet sheet, Cell dataCell, DataProvider<T, ?> dataProvider, CellRangeAddress dataRange, boolean titleExists) {
        Stream<T> dataStream = this.obtainDataStream(dataProvider);
        boolean notFirstRow = false;
        Cell startingCell = dataCell;
        Iterable items = dataStream::iterator;
        for (Object item : items) {
            if (notFirstRow) {
                CellStyle cellStyle = startingCell.getCellStyle();
                Row newRow = sheet.createRow(startingCell.getRowIndex() + 1);
                startingCell = newRow.createCell(startingCell.getColumnIndex());
                startingCell.setCellStyle(cellStyle);
            }
            dataRange.setLastRow(dataRange.getLastRow() + 1);
            this.buildRow(item, sheet, startingCell);
            notFirstRow = true;
        }
        dataRange.setLastColumn(dataRange.getLastColumn() + this.exporter.getColumns().size() - 1);
        return dataRange.getLastRow();
    }

    private void buildRow(T item, Sheet sheet, Cell startingCell) {
        if (this.exporter.propertySet == null) {
            this.exporter.propertySet = BeanPropertySet.get(item.getClass());
        }
        if (this.exporter.getColumns().isEmpty()) {
            throw new IllegalStateException("Grid has no columns");
        }
        int[] currentColumn = new int[]{startingCell.getColumnIndex()};
        this.exporter.getColumnsOrdered().stream().forEach(column -> {
            Object value = this.exporter.extractValueFromColumn(item, column);
            value = this.transformToType(value, (Grid.Column<T>)column);
            Cell currentCell = startingCell;
            if (startingCell.getColumnIndex() < currentColumn[0]) {
                currentCell = startingCell.getRow().createCell(currentColumn[0]);
                currentCell.setCellStyle(startingCell.getCellStyle());
                this.configureAlignment((Grid.Column<T>)column, currentCell, ExcelCellType.CELL);
            }
            currentColumn[0] = currentColumn[0] + 1;
            this.buildCell(value, currentCell, (Grid.Column<T>)column, item);
        });
    }

    private Object transformToType(Object value, Grid.Column<T> column) {
        Object result = value;
        if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
            String stringValue = (String)value;
            try {
                if (ComponentUtil.getData(column, (String)"column-parsing-format-pattern-data") != null) {
                    switch ((String)ComponentUtil.getData(column, (String)"column-type-data")) {
                        case "number": {
                            DecimalFormat decimalFormat = (DecimalFormat)ComponentUtil.getData(column, (String)"column-parsing-format-pattern-data");
                            decimalFormat.setParseBigDecimal(true);
                            result = decimalFormat.parse(stringValue).doubleValue();
                            break;
                        }
                        case "date": {
                            result = ((DateFormat)ComponentUtil.getData(column, (String)"column-parsing-format-pattern-data")).parse(stringValue);
                        }
                    }
                }
            }
            catch (ParseException e) {
                throw new IllegalStateException("Problem parsing grid cell value", e);
            }
        }
        return result;
    }

    private void configureAlignment(Grid.Column<T> column, Cell currentCell, ExcelCellType type) {
        ColumnTextAlign columnTextAlign = column.getTextAlign();
        switch (columnTextAlign) {
            case START: {
                if (currentCell.getCellStyle().getAlignment().equals((Object)HorizontalAlignment.LEFT)) break;
                currentCell.setCellStyle(this.createOrRetrieveCellStyle(HorizontalAlignment.LEFT, currentCell, column, type));
                break;
            }
            case CENTER: {
                if (currentCell.getCellStyle().getAlignment().equals((Object)HorizontalAlignment.CENTER)) break;
                currentCell.setCellStyle(this.createOrRetrieveCellStyle(HorizontalAlignment.CENTER, currentCell, column, type));
                break;
            }
            case END: {
                if (currentCell.getCellStyle().getAlignment().equals((Object)HorizontalAlignment.RIGHT)) break;
                currentCell.setCellStyle(this.createOrRetrieveCellStyle(HorizontalAlignment.RIGHT, currentCell, column, type));
                break;
            }
            default: {
                currentCell.setCellStyle(currentCell.getCellStyle());
            }
        }
    }

    private CellStyle createOrRetrieveCellStyle(HorizontalAlignment alignment, Cell currentCell, Grid.Column<T> column, ExcelCellType type) {
        CellStyle cellStyle;
        HashMap<String, CellStyle> cellStyles = (HashMap<String, CellStyle>)ComponentUtil.getData(column, (String)COLUMN_CELLSTYLE_MAP);
        if (cellStyles == null) {
            cellStyles = new HashMap<String, CellStyle>();
            ComponentUtil.setData(column, (String)COLUMN_CELLSTYLE_MAP, cellStyles);
        }
        if (cellStyles.get(type.name()) == null) {
            cellStyle = currentCell.getSheet().getWorkbook().createCellStyle();
            cellStyle.cloneStyleFrom(currentCell.getCellStyle());
            cellStyle.setAlignment(alignment);
            cellStyles.put(type.name(), cellStyle);
        } else {
            cellStyle = (CellStyle)cellStyles.get(type.name());
        }
        return cellStyle;
    }

    private void buildCell(Object value, Cell cell, Grid.Column<T> column, T item) {
        ValueProvider provider = null;
        provider = (ValueProvider)ComponentUtil.getData(column, (String)"column-excel-format-data-provider");
        HashMap<String, CellStyle> cellStyles = (HashMap<String, CellStyle>)ComponentUtil.getData(column, (String)COLUMN_CELLSTYLE_MAP);
        if (cellStyles == null) {
            cellStyles = new HashMap<String, CellStyle>();
            ComponentUtil.setData(column, (String)COLUMN_CELLSTYLE_MAP, cellStyles);
        }
        String excelFormat = provider != null ? (String)provider.apply(item) : (String)ComponentUtil.getData(column, (String)"column-excel-format-data");
        if (value == null) {
            PoiHelper.setBlank(cell);
        } else if (value instanceof Number) {
            excelFormat = excelFormat != null ? excelFormat : "0";
            cell.setCellValue(((Number)value).doubleValue());
            this.applyExcelFormat(cell, excelFormat, cellStyles);
        } else if (value instanceof Date) {
            excelFormat = excelFormat != null ? excelFormat : "dd/MM/yyyy";
            this.applyExcelFormat(cell, excelFormat, cellStyles);
            cell.setCellValue((Date)value);
        } else if (value instanceof LocalDate) {
            excelFormat = excelFormat != null ? excelFormat : "dd/MM/yyyy";
            this.applyExcelFormat(cell, excelFormat, cellStyles);
            cell.setCellValue(Date.from(((LocalDate)value).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        } else {
            cell.setCellValue(value.toString());
        }
    }

    private void applyExcelFormat(Cell cell, String excelFormat, Map<String, CellStyle> cellStyles) {
        DataFormat format = cell.getSheet().getWorkbook().createDataFormat();
        if (excelFormat != null && cellStyles.get(excelFormat) == null) {
            CellStyle cs = cell.getSheet().getWorkbook().createCellStyle();
            cs.cloneStyleFrom(cell.getCellStyle());
            cellStyles.put(excelFormat, cs);
            cell.setCellStyle(cs);
        } else if (excelFormat != null) {
            cell.setCellStyle(cellStyles.get(excelFormat));
        }
        cell.getCellStyle().setDataFormat(format.getFormat(excelFormat));
    }

    private Workbook getBaseTemplateWorkbook() {
        try {
            InputStream inp = this.getClass().getResourceAsStream(this.template);
            Workbook result = WorkbookFactory.create((InputStream)inp);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem creating workbook", e);
        }
    }

    private Cell findCellWithPlaceHolder(Sheet sheet, String placeholder) {
        for (Row row : sheet) {
            for (Cell cell : row) {
                if (!PoiHelper.cellTypeEquals(cell, CellType.STRING) || !cell.getRichStringCellValue().getString().trim().equals(placeholder)) continue;
                return cell;
            }
        }
        return null;
    }

    private void fillHeaderOrFooter(Sheet sheet, Cell headersOrFootersCell, List<Pair<String, Grid.Column<T>>> headersOrFooters, boolean isHeader) {
        CellStyle style = headersOrFootersCell.getCellStyle();
        sheet.setActiveCell(headersOrFootersCell.getAddress());
        headersOrFooters.forEach(headerOrFooter -> {
            Cell cell;
            if (!isHeader) {
                ComponentUtil.setData((Component)((Component)headerOrFooter.getRight()), (String)COLUMN_CELLSTYLE_MAP, null);
            }
            if ((cell = sheet.getRow(sheet.getActiveCell().getRow()).getCell(sheet.getActiveCell().getColumn())) == null) {
                cell = sheet.getRow(sheet.getActiveCell().getRow()).createCell(sheet.getActiveCell().getColumn());
            }
            cell.setCellStyle(style);
            Object value = isHeader ? headerOrFooter.getLeft() : this.transformToType(headerOrFooter.getLeft(), (Grid.Column)headerOrFooter.getRight());
            this.buildCell(value, cell, (Grid.Column)headerOrFooter.getRight(), null);
            this.configureAlignment((Grid.Column)headerOrFooter.getRight(), cell, isHeader ? ExcelCellType.HEADER : ExcelCellType.FOOTER);
            sheet.setActiveCell(new CellAddress(sheet.getActiveCell().getRow(), sheet.getActiveCell().getColumn() + 1));
        });
    }

    private static enum ExcelCellType {
        HEADER,
        CELL,
        FOOTER;

    }
}

