/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.dataview.GridLazyDataView;
import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.server.InputStreamFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseInputStreamFactory<T>
implements InputStreamFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseInputStreamFactory.class);
    protected GridExporter<T> exporter;
    protected String template;

    public BaseInputStreamFactory(GridExporter<T> exporter) {
        this.exporter = exporter;
    }

    public BaseInputStreamFactory(GridExporter<T> exporter, String customTemplate, String defaultTemplate) {
        this.exporter = exporter;
        this.template = customTemplate == null ? defaultTemplate : customTemplate;
    }

    protected boolean isExportable(Grid.Column<T> column) {
        Boolean exported = (Boolean)ComponentUtil.getData(column, (String)"column-value-exported-data");
        return exported != null ? exported.booleanValue() : column.isVisible();
    }

    protected Stream<T> getDataStream(Query newQuery) {
        Stream stream = this.exporter.grid.getDataProvider().fetch(newQuery);
        if (stream.isParallel()) {
            LoggerFactory.getLogger(DataCommunicator.class).debug("Data provider {} has returned parallel stream on 'fetch' call", this.exporter.grid.getDataProvider().getClass());
            stream = stream.collect(Collectors.toList()).stream();
            assert (!stream.isParallel());
        }
        return stream;
    }

    protected List<Pair<String, Grid.Column<T>>> getGridHeaders(Grid<T> grid) {
        return this.exporter.getColumnsOrdered().stream().map(column -> ImmutablePair.of((Object)this.renderCellTextContent(grid, (Grid.Column<T>)column, "column-header"), (Object)column)).collect(Collectors.toList());
    }

    protected List<Pair<String, Grid.Column<T>>> getGridFooters(Grid<T> grid) {
        return this.exporter.getColumnsOrdered().stream().map(column -> ImmutablePair.of((Object)this.renderCellTextContent(grid, (Grid.Column<T>)column, "column-footer"), (Object)column)).collect(Collectors.toList());
    }

    private String renderCellTextContent(Grid<T> grid, Grid.Column<T> column, String columnType) {
        String headerOrFooter = (String)ComponentUtil.getData(column, (String)columnType);
        if (Strings.isBlank((String)headerOrFooter)) {
            Function<Grid.Column, Component> getHeaderOrFooterComponent;
            if ("column-header".equals(columnType)) {
                getHeaderOrFooterComponent = rec$ -> ((Grid.Column)rec$).getHeaderComponent();
                headerOrFooter = column.getHeaderText();
            } else if ("column-footer".equals(columnType)) {
                getHeaderOrFooterComponent = rec$ -> ((Grid.Column)rec$).getFooterComponent();
                headerOrFooter = column.getFooterText();
            } else {
                throw new IllegalArgumentException();
            }
            if (Strings.isBlank((String)headerOrFooter)) {
                try {
                    Component component = getHeaderOrFooterComponent.apply(column);
                    if (component != null) {
                        headerOrFooter = component.getElement().getTextRecursively();
                    }
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Problem when trying to render header or footer cell text content", e);
                }
            }
        }
        return headerOrFooter;
    }

    protected Stream<T> obtainDataStream(DataProvider<T, ?> dataProvider) {
        Stream<T> dataStream;
        Object filter = null;
        try {
            Method method = DataCommunicator.class.getDeclaredMethod("getFilter", new Class[0]);
            method.setAccessible(true);
            filter = method.invoke((Object)this.exporter.grid.getDataCommunicator(), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get filter from DataCommunicator", (Throwable)e);
        }
        if (this.exporter.grid.getDataProvider() instanceof HierarchicalDataProvider) {
            return this.obtainFlattenedHierarchicalDataStream(this.exporter.grid);
        }
        if (dataProvider instanceof AbstractBackEndDataProvider) {
            GridLazyDataView gridLazyDataView = this.exporter.grid.getLazyDataView();
            dataStream = gridLazyDataView.getItems();
        } else {
            Query streamQuery = new Query(0, this.exporter.grid.getDataProvider().size(new Query(filter)), this.exporter.grid.getDataCommunicator().getBackEndSorting(), (Comparator)this.exporter.grid.getDataCommunicator().getInMemorySorting(), filter);
            dataStream = this.getDataStream(streamQuery);
        }
        return dataStream;
    }

    protected Stream<T> obtainFlattenedHierarchicalDataStream(Grid<T> grid) {
        ArrayList<Object> flattenedData = this.fetchDataRecursive(grid, null);
        return flattenedData.stream();
    }

    protected ArrayList<T> fetchDataRecursive(Grid<T> grid, T parent) {
        HierarchicalDataProvider hDataProvider;
        int childCount;
        ArrayList<T> result = new ArrayList<T>();
        if (parent != null) {
            result.add(parent);
        }
        if ((childCount = (hDataProvider = (HierarchicalDataProvider)grid.getDataProvider()).getChildCount(new HierarchicalQuery(0, Integer.MAX_VALUE, grid.getSortOrder().stream().flatMap(so -> so.getSorted().getSortOrder(so.getDirection())).collect(Collectors.toList()), (Comparator)grid.getDataCommunicator().getInMemorySorting(), null, parent))) > 0) {
            hDataProvider.fetchChildren(new HierarchicalQuery(0, Integer.MAX_VALUE, grid.getSortOrder().stream().flatMap(so -> so.getSorted().getSortOrder(so.getDirection())).collect(Collectors.toList()), (Comparator)grid.getDataCommunicator().getInMemorySorting(), null, parent)).forEach(child -> {
                ArrayList<Object> subTree = this.fetchDataRecursive(grid, child);
                result.addAll(subTree);
            });
        }
        return result;
    }
}

