/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.BaseInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.PoiHelper;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.provider.DataProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExcelInputStreamFactory<T>
extends BaseInputStreamFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelInputStreamFactory.class);
    private static final String DEFAULT_TEMPLATE = "/template.xlsx";

    public ExcelInputStreamFactory(GridExporter<T> exporter, String template) {
        super(exporter, template, DEFAULT_TEMPLATE);
    }

    public InputStream createInputStream() {
        PipedInputStream in = new PipedInputStream();
        try {
            this.exporter.setColumns(this.exporter.grid.getColumns().stream().filter(this::isExportable).collect(Collectors.toList()));
            final Workbook wb = this.getBaseTemplateWorkbook();
            Sheet sheet = wb.getSheetAt(this.exporter.sheetNumber);
            Cell titleCell = this.findCellWithPlaceHolder(sheet, this.exporter.titlePlaceHolder);
            if (titleCell != null) {
                titleCell.setCellValue(this.exporter.title);
            }
            Cell cell = this.findCellWithPlaceHolder(sheet, this.exporter.headersPlaceHolder);
            List headers = this.getGridHeaders(this.exporter.grid);
            this.fillHeaderOrFooter(sheet, cell, headers, true);
            if (this.exporter.autoMergeTitle && titleCell != null) {
                sheet.addMergedRegion(new CellRangeAddress(titleCell.getRowIndex(), titleCell.getRowIndex(), titleCell.getColumnIndex(), titleCell.getColumnIndex() + headers.size() - 1));
            }
            cell = this.findCellWithPlaceHolder(sheet, this.exporter.dataPlaceHolder);
            int[] dataStartingColumn = new int[]{cell.getColumnIndex()};
            this.fillData(sheet, cell, this.exporter.grid.getDataProvider(), titleCell != null);
            cell = this.findCellWithPlaceHolder(sheet, this.exporter.footersPlaceHolder);
            List footers = this.getGridFooters(this.exporter.grid);
            if (cell != null) {
                this.fillHeaderOrFooter(sheet, cell, footers, false);
            }
            if (this.exporter.isAutoSizeColumns()) {
                this.exporter.getColumns().forEach(column -> {
                    sheet.autoSizeColumn(dataStartingColumn[0]);
                    dataStartingColumn[0] = dataStartingColumn[0] + 1;
                });
            }
            this.exporter.additionalPlaceHolders.entrySet().forEach(entry -> {
                Cell cellwp = this.findCellWithPlaceHolder(sheet, (String)entry.getKey());
                while (cellwp != null) {
                    cellwp.setCellValue((String)entry.getValue());
                    cellwp = this.findCellWithPlaceHolder(sheet, (String)entry.getKey());
                }
            });
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        wb.write((OutputStream)out);
                    }
                    catch (IOException e) {
                        LOGGER.error("Problem generating export", (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                LOGGER.error("Problem generating export", (Throwable)e);
                            }
                        }
                    }
                }
            }).start();
        }
        catch (IOException e) {
            LOGGER.error("Problem generating export", (Throwable)e);
        }
        return in;
    }

    private void fillData(Sheet sheet, Cell dataCell, DataProvider<T, ?> dataProvider, boolean titleExists) {
        Stream<Object> dataStream = this.obtainDataStream(dataProvider);
        boolean[] notFirstRow = new boolean[1];
        Cell[] startingCell = new Cell[]{dataCell};
        dataStream.forEach(t -> {
            if (notFirstRow[0]) {
                CellStyle cellStyle = startingCell[0].getCellStyle();
                int lastRow = sheet.getLastRowNum();
                sheet.shiftRows(startingCell[0].getRowIndex() + (titleExists ? 1 : 0), lastRow, titleExists ? 1 : 0);
                Row newRow = sheet.createRow(startingCell[0].getRowIndex() + 1);
                startingCell[0] = newRow.createCell(startingCell[0].getColumnIndex());
                startingCell[0].setCellStyle(cellStyle);
            }
            this.buildRow(t, sheet, startingCell[0]);
            notFirstRow[0] = true;
        });
    }

    private void buildRow(T item, Sheet sheet, Cell startingCell) {
        if (this.exporter.propertySet == null) {
            this.exporter.propertySet = BeanPropertySet.get(item.getClass());
        }
        if (this.exporter.getColumns().isEmpty()) {
            throw new IllegalStateException("Grid has no columns");
        }
        int[] currentColumn = new int[]{startingCell.getColumnIndex()};
        this.exporter.getColumnsOrdered().stream().forEach(column -> {
            Object value = this.exporter.extractValueFromColumn(item, column);
            value = this.transformToType(value, (Grid.Column<T>)column);
            Cell currentCell = startingCell;
            if (startingCell.getColumnIndex() < currentColumn[0]) {
                currentCell = startingCell.getRow().createCell(currentColumn[0]);
                CellStyle newCellStyle = currentCell.getSheet().getWorkbook().createCellStyle();
                newCellStyle.cloneStyleFrom(startingCell.getCellStyle());
                currentCell.setCellStyle(newCellStyle);
                this.configureAlignment(column.getTextAlign(), currentCell);
            }
            currentColumn[0] = currentColumn[0] + 1;
            this.buildCell(value, currentCell, (Grid.Column<T>)column);
        });
    }

    private Object transformToType(Object value, Grid.Column<T> column) {
        Object result = value;
        if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
            String stringValue = (String)value;
            try {
                if (ComponentUtil.getData(column, (String)"column-parsing-format-pattern-data") != null) {
                    switch ((String)ComponentUtil.getData(column, (String)"column-type-data")) {
                        case "number": {
                            DecimalFormat decimalFormat = (DecimalFormat)ComponentUtil.getData(column, (String)"column-parsing-format-pattern-data");
                            decimalFormat.setParseBigDecimal(true);
                            result = decimalFormat.parse(stringValue).doubleValue();
                            break;
                        }
                        case "date": {
                            result = ((DateFormat)ComponentUtil.getData(column, (String)"column-parsing-format-pattern-data")).parse(stringValue);
                        }
                    }
                }
            }
            catch (ParseException e) {
                throw new IllegalStateException("Problem parsing grid cell value", e);
            }
        }
        return result;
    }

    protected void configureAlignment(ColumnTextAlign columnTextAlign, Cell currentCell) {
        switch (columnTextAlign) {
            case START: {
                currentCell.getCellStyle().setAlignment(HorizontalAlignment.LEFT);
                break;
            }
            case CENTER: {
                currentCell.getCellStyle().setAlignment(HorizontalAlignment.CENTER);
                break;
            }
            case END: {
                currentCell.getCellStyle().setAlignment(HorizontalAlignment.RIGHT);
                break;
            }
            default: {
                currentCell.getCellStyle().setAlignment(HorizontalAlignment.LEFT);
            }
        }
    }

    private void buildCell(Object value, Cell cell, Grid.Column<T> column) {
        String excelFormat = (String)ComponentUtil.getData(column, (String)"column-excel-format-data");
        if (value == null) {
            PoiHelper.setBlank(cell);
        } else if (value instanceof Number) {
            this.applyExcelFormat(cell, excelFormat);
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Date) {
            this.applyExcelFormat(cell, excelFormat);
            cell.setCellValue((Date)value);
        } else if (value instanceof LocalDate) {
            this.applyExcelFormat(cell, excelFormat);
            cell.setCellValue(Date.from(((LocalDate)value).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        } else {
            cell.setCellValue(value.toString());
        }
    }

    private void applyExcelFormat(Cell cell, String excelFormat) {
        DataFormat format = cell.getSheet().getWorkbook().createDataFormat();
        cell.getCellStyle().setDataFormat(format.getFormat(excelFormat));
    }

    private Workbook getBaseTemplateWorkbook() {
        try {
            InputStream inp = this.getClass().getResourceAsStream(this.template);
            Workbook result = WorkbookFactory.create((InputStream)inp);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem creating workbook", e);
        }
    }

    private Cell findCellWithPlaceHolder(Sheet sheet, String placeholder) {
        for (Row row : sheet) {
            for (Cell cell : row) {
                if (!PoiHelper.cellTypeEquals(cell, CellType.STRING) || !cell.getRichStringCellValue().getString().trim().equals(placeholder)) continue;
                return cell;
            }
        }
        return null;
    }

    private void fillHeaderOrFooter(Sheet sheet, Cell headersOrFootersCell, List<Pair<String, Grid.Column<T>>> headersOrFooters, boolean isHeader) {
        CellStyle style = headersOrFootersCell.getCellStyle();
        sheet.setActiveCell(headersOrFootersCell.getAddress());
        headersOrFooters.forEach(headerOrFooter -> {
            Cell cell = sheet.getRow(sheet.getActiveCell().getRow()).getCell(sheet.getActiveCell().getColumn());
            if (cell == null) {
                cell = sheet.getRow(sheet.getActiveCell().getRow()).createCell(sheet.getActiveCell().getColumn());
                CellStyle newCellStyle = cell.getSheet().getWorkbook().createCellStyle();
                newCellStyle.cloneStyleFrom(style);
                cell.setCellStyle(newCellStyle);
            }
            Object value = isHeader ? headerOrFooter.getLeft() : this.transformToType(headerOrFooter.getLeft(), (Grid.Column)headerOrFooter.getRight());
            this.buildCell(value, cell, (Grid.Column)headerOrFooter.getRight());
            this.configureAlignment(((Grid.Column)headerOrFooter.getRight()).getTextAlign(), cell);
            sheet.setActiveCell(new CellAddress(sheet.getActiveCell().getRow(), sheet.getActiveCell().getColumn() + 1));
        });
    }
}

