/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.dataview.GridLazyDataView;
import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.server.InputStreamFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseInputStreamFactory<T>
implements InputStreamFactory {
    private static final String GET_FOOTER_COMPONENT_METHOD_NAME = "getFooterComponent";
    private static final String GET_HEADER_COMPONENT_METHOD_NAME = "getHeaderComponent";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseInputStreamFactory.class);
    protected GridExporter<T> exporter;
    protected String template;

    public BaseInputStreamFactory(GridExporter<T> exporter) {
        this.exporter = exporter;
    }

    public BaseInputStreamFactory(GridExporter<T> exporter, String customTemplate, String defaultTemplate) {
        this.exporter = exporter;
        this.template = customTemplate == null ? defaultTemplate : customTemplate;
    }

    protected boolean isExportable(Grid.Column<T> column) {
        Boolean exported = (Boolean)ComponentUtil.getData(column, (String)"column-value-exported-data");
        return exported != null ? exported.booleanValue() : column.isVisible();
    }

    protected Stream<T> getDataStream(Query newQuery) {
        Stream stream = this.exporter.grid.getDataProvider().fetch(newQuery);
        if (stream.isParallel()) {
            LoggerFactory.getLogger(DataCommunicator.class).debug("Data provider {} has returned parallel stream on 'fetch' call", this.exporter.grid.getDataProvider().getClass());
            stream = stream.collect(Collectors.toList()).stream();
            assert (!stream.isParallel());
        }
        return stream;
    }

    protected List<Pair<String, Grid.Column<T>>> getGridHeaders(Grid<T> grid) {
        return this.exporter.getColumnsOrdered().stream().map(column -> ImmutablePair.of((Object)this.renderCellTextContent(grid, (Grid.Column<T>)column, "column-header"), (Object)column)).collect(Collectors.toList());
    }

    protected List<Pair<String, Grid.Column<T>>> getGridFooters(Grid<T> grid) {
        return this.exporter.getColumnsOrdered().stream().map(column -> ImmutablePair.of((Object)this.renderCellTextContent(grid, (Grid.Column<T>)column, "column-footer"), (Object)column)).collect(Collectors.toList());
    }

    private String renderCellTextContent(Grid<T> grid, Grid.Column<T> column, String columnType) {
        String headerOrFooter = (String)ComponentUtil.getData(column, (String)columnType);
        String methodName = GET_HEADER_COMPONENT_METHOD_NAME;
        if (Strings.isBlank((String)headerOrFooter)) {
            if ("column-header".equals(columnType)) {
                headerOrFooter = GridHelper.getHeader(grid, column);
            } else if ("column-footer".equals(columnType)) {
                methodName = GET_FOOTER_COMPONENT_METHOD_NAME;
                headerOrFooter = GridHelper.getFooter(grid, column);
            }
        }
        if (Strings.isBlank((String)headerOrFooter)) {
            try {
                Method getHeaderOrFooterComponent = Grid.Column.class.getMethod(methodName, new Class[0]);
                Component component = (Component)getHeaderOrFooterComponent.invoke(column, new Object[0]);
                if (component != null) {
                    headerOrFooter = component.getElement().getTextRecursively();
                }
            }
            catch (NoSuchMethodException e) {
                headerOrFooter = "";
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException("Problem when trying to render header or footer cell text content", e);
            }
        }
        return headerOrFooter;
    }

    protected Stream<T> obtainDataStream(DataProvider<T, ?> dataProvider) {
        Stream<T> dataStream;
        Object filter = null;
        try {
            Method method = DataCommunicator.class.getDeclaredMethod("getFilter", new Class[0]);
            method.setAccessible(true);
            filter = method.invoke((Object)this.exporter.grid.getDataCommunicator(), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get filter from DataCommunicator", (Throwable)e);
        }
        if (dataProvider instanceof AbstractBackEndDataProvider) {
            GridLazyDataView gridLazyDataView = this.exporter.grid.getLazyDataView();
            dataStream = gridLazyDataView.getItems();
        } else {
            Query streamQuery = new Query(0, this.exporter.grid.getDataProvider().size(new Query(filter)), this.exporter.grid.getDataCommunicator().getBackEndSorting(), (Comparator)this.exporter.grid.getDataCommunicator().getInMemorySorting(), null);
            dataStream = this.getDataStream(streamQuery);
        }
        return dataStream;
    }
}

