/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.BaseInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.opencsv.CSVWriter;
import com.vaadin.flow.data.binder.BeanPropertySet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CsvInputStreamFactory<T>
extends BaseInputStreamFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvInputStreamFactory.class);

    public CsvInputStreamFactory(GridExporter<T> exporter) {
        super(exporter, null, null);
    }

    public InputStream createInputStream() {
        PipedInputStream in = new PipedInputStream();
        try {
            this.exporter.columns = this.exporter.grid.getColumns().stream().filter(this::isExportable).collect(Collectors.toList());
            String[] headers = (String[])this.getGridHeaders(this.exporter.grid).stream().map(Pair::getLeft).toArray(String[]::new);
            List data = this.obtainDataStream(this.exporter.grid.getDataProvider()).map(this::buildRow).collect(Collectors.toList());
            String[] footers = (String[])this.getGridFooters(this.exporter.grid).stream().filter(pair -> StringUtils.isNotBlank((CharSequence)((CharSequence)pair.getKey()))).map(Pair::getLeft).toArray(String[]::new);
            PipedOutputStream out = new PipedOutputStream(in);
            new Thread(() -> {
                try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(out));){
                    writer.writeNext(headers);
                    writer.writeAll(data);
                    if (footers.length > 0) {
                        writer.writeNext(footers);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Problem generating export", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }).start();
        }
        catch (IOException e) {
            LOGGER.error("Problem generating export", (Throwable)e);
        }
        return in;
    }

    private String[] buildRow(T item) {
        if (this.exporter.propertySet == null) {
            this.exporter.propertySet = BeanPropertySet.get(item.getClass());
        }
        if (this.exporter.columns.isEmpty()) {
            throw new IllegalStateException("Grid has no columns");
        }
        String[] result = new String[this.exporter.columns.size()];
        int[] currentColumn = new int[1];
        this.exporter.columns.forEach(column -> {
            Object value = this.exporter.extractValueFromColumn(item, column);
            result[currentColumn[0]] = "" + value;
            currentColumn[0] = currentColumn[0] + 1;
        });
        return result;
    }
}

