/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.LocalDateRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.EncryptedDocumentException;

@DemoSource
@PageTitle(value="Grid Exporter Addon Simple Custom Templates Demo")
@Route(value="gridexporter/simple-custom", layout=GridExporterDemoView.class)
public class GridExporterSimpleCustomTemplateDemo
extends Div {
    public GridExporterSimpleCustomTemplateDemo() throws EncryptedDocumentException, IOException {
        Grid grid = new Grid(Person.class);
        grid.removeAllColumns();
        grid.addColumn((Renderer)LitRenderer.of((String)"<b>${item.name}</b>").withProperty("name", Person::getName)).setHeader("Name");
        grid.addColumn("lastName").setHeader("Last Name");
        Grid.Column c = grid.addColumn((ValueProvider & Serializable)item -> "$" + item.getBudget()).setHeader("Budget");
        grid.addColumn((Renderer)new LocalDateRenderer(Person::getFavDate, DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM))).setHeader("Fav Date");
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
        Stream<Person> stream = IntStream.range(0, 100).asLongStream().mapToObj(number -> {
            Faker faker = new Faker();
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            return new Person(faker.name().firstName(), faker.name().lastName(), faker.number().numberBetween(15, 50), budget, Instant.ofEpochMilli(faker.date().past(10000, TimeUnit.DAYS).getTime()).atZone(ZoneId.systemDefault()).toLocalDate());
        });
        grid.setItems(DataProvider.fromStream(stream));
        grid.setWidthFull();
        this.setSizeFull();
        GridExporter exporter = GridExporter.createFor((Grid)grid, (String)"/simple-custom-template.xlsx", (String)"/simple-custom-template.docx");
        exporter.setSheetNumber(1);
        exporter.setCsvExportEnabled(false);
        exporter.setFileName("GridExport" + new SimpleDateFormat("yyyyddMM").format(Calendar.getInstance().getTime()));
        this.add(new Component[]{grid});
    }
}

