/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;

public class PoiHelper {
    private static final String XWPF_TABLE_CELL_CLASS_NAME = "XWPFTableCell";
    private static final String CT_TBL_GRID_COL_CLASS_NAME = "CTTblGridCol";
    private static final String CT_TBL_WIDTH_CLASS_NAME = "CTTblWidth";
    private static final String CELL_CLASS_NAME = "Cell";
    private static final String SET_WIDTH_METHOD_NAME = "setWidth";
    private static final String SET_W_METHOD_NAME = "setW";
    private static final String GET_CELL_TYPE_METHOD_NAME = "getCellType";
    private static final String SET_BLANK_METHOD_NAME = "setBlank";
    private static final String PROBLEM_WHEN_CALLING_METHOD_ON_EXCEPTION_MESSAGE = "Problem when calling method %s() on class %s";

    public static void setBlank(Cell cell) {
        try {
            Method setBlank = Cell.class.getMethod(SET_BLANK_METHOD_NAME, new Class[0]);
            setBlank.invoke((Object)cell, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            cell.setCellType(CellType.BLANK);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(String.format(PROBLEM_WHEN_CALLING_METHOD_ON_EXCEPTION_MESSAGE, SET_BLANK_METHOD_NAME, CELL_CLASS_NAME), e);
        }
    }

    public static boolean cellTypeEquals(Cell cell, CellType cellType) {
        boolean result = false;
        try {
            Method getCellType = Cell.class.getMethod(GET_CELL_TYPE_METHOD_NAME, new Class[0]);
            result = getCellType.getReturnType().isPrimitive() ? getCellType.invoke((Object)cell, new Object[0]).equals(cellType.getCode()) : getCellType.invoke((Object)cell, new Object[0]).equals(cellType);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(String.format(PROBLEM_WHEN_CALLING_METHOD_ON_EXCEPTION_MESSAGE, GET_CELL_TYPE_METHOD_NAME, CELL_CLASS_NAME), e);
        }
        return result;
    }

    public static void setWonCTTblWidth(CTTblWidth tblW, String string) {
        try {
            Method setW = CTTblWidth.class.getMethod(SET_W_METHOD_NAME, Object.class);
            setW.invoke((Object)tblW, string);
        }
        catch (NoSuchMethodException e) {
            try {
                Method setWBigInteger = CTTblWidth.class.getMethod(SET_W_METHOD_NAME, BigInteger.class);
                setWBigInteger.invoke((Object)tblW, new BigInteger(string));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                throw new IllegalStateException(String.format(PROBLEM_WHEN_CALLING_METHOD_ON_EXCEPTION_MESSAGE, SET_W_METHOD_NAME, CT_TBL_WIDTH_CLASS_NAME), e1);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(String.format(PROBLEM_WHEN_CALLING_METHOD_ON_EXCEPTION_MESSAGE, SET_W_METHOD_NAME, CT_TBL_WIDTH_CLASS_NAME), e);
        }
    }

    public static void setWonCTTblGridCol(CTTblGridCol cctblgridcol, String string) {
        try {
            Method setW = CTTblGridCol.class.getMethod(SET_W_METHOD_NAME, Object.class);
            setW.invoke((Object)cctblgridcol, string);
        }
        catch (NoSuchMethodException e) {
            try {
                Method setWBigInteger = CTTblGridCol.class.getMethod(SET_W_METHOD_NAME, BigInteger.class);
                setWBigInteger.invoke((Object)cctblgridcol, new BigInteger(string));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                throw new IllegalStateException(String.format(PROBLEM_WHEN_CALLING_METHOD_ON_EXCEPTION_MESSAGE, SET_W_METHOD_NAME, CT_TBL_GRID_COL_CLASS_NAME), e1);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(String.format(PROBLEM_WHEN_CALLING_METHOD_ON_EXCEPTION_MESSAGE, SET_W_METHOD_NAME, CT_TBL_GRID_COL_CLASS_NAME), e);
        }
    }

    public static void setWidth(XWPFTableCell currentCell, String string) {
        try {
            Method setW = XWPFTableCell.class.getMethod(SET_WIDTH_METHOD_NAME, String.class);
            setW.invoke((Object)currentCell, string);
        }
        catch (NoSuchMethodException setW) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(String.format(PROBLEM_WHEN_CALLING_METHOD_ON_EXCEPTION_MESSAGE, SET_WIDTH_METHOD_NAME, XWPF_TABLE_CELL_CLASS_NAME), e);
        }
    }
}

