/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridexporter.FakerInstance;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.LocalDateRenderer;
import com.vaadin.flow.data.renderer.NumberRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.EncryptedDocumentException;

@DemoSource
@PageTitle(value="Simple Custom Templates")
@Route(value="gridexporter/simple-custom", layout=GridExporterDemoView.class)
public class GridExporterSimpleCustomTemplateDemo
extends Div {
    private static final Faker faker = FakerInstance.get();

    public GridExporterSimpleCustomTemplateDemo() throws EncryptedDocumentException, IOException {
        DecimalFormat decimalFormat = new DecimalFormat("$#,###.##");
        Grid grid = new Grid(Person.class);
        grid.removeAllColumns();
        grid.addColumn((Renderer)LitRenderer.of((String)"<b>${item.name}</b>").withProperty("name", Person::getName)).setHeader("Name");
        grid.addColumn("lastName").setHeader("Last Name");
        Grid.Column minBudgetColumn = (Grid.Column)grid.addColumn((Renderer)new NumberRenderer(Person::getBudget, NumberFormat.getCurrencyInstance())).setHeader("Min. Budget").setTextAlign(ColumnTextAlign.END);
        Grid.Column maxBudgetColumn = (Grid.Column)grid.addColumn((ValueProvider & Serializable)item -> decimalFormat.format(item.getBudget() + item.getBudget() / 2.0)).setHeader("Max. Budget").setTextAlign(ColumnTextAlign.END);
        Grid.Column quantityColumn = (Grid.Column)grid.addColumn((ValueProvider & Serializable)item -> decimalFormat.format(item.getBudget() + (double)new Random().nextInt(10))).setHeader("Quantity").setTextAlign(ColumnTextAlign.END);
        Grid.Column dateColumn1 = (Grid.Column)grid.addColumn((Renderer)new LocalDateRenderer(Person::getFavDate, "dd/MM/yyyy")).setHeader("Fav Date").setTextAlign(ColumnTextAlign.CENTER);
        Grid.Column dateColumn2 = (Grid.Column)grid.addColumn((ValueProvider & Serializable)item -> item.getWorstDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"))).setHeader("Worst Date").setTextAlign(ColumnTextAlign.CENTER);
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
        Stream<Person> stream = IntStream.range(0, 100).asLongStream().mapToObj(number -> {
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            return new Person(faker.name().firstName(), faker.name().lastName(), faker.number().numberBetween(15, 50), budget, this.createRandomDate(faker), this.createRandomDate(faker));
        });
        grid.setItems(DataProvider.fromStream(stream));
        grid.setWidthFull();
        this.setSizeFull();
        GridExporter exporter = GridExporter.createFor((Grid)grid, (String)"/simple-custom-template.xlsx", (String)"/simple-custom-template.docx");
        exporter.setSheetNumber(1);
        exporter.setCsvExportEnabled(false);
        exporter.setAutoSizeColumns(false);
        exporter.setNumberColumnFormat(minBudgetColumn, "$#.###,##");
        exporter.setNumberColumnFormat(maxBudgetColumn, decimalFormat, "$#,###.##");
        exporter.setNumberColumnFormatProvider(quantityColumn, decimalFormat, (ValueProvider & Serializable)person -> person == null ? "" : (person.getBudget() > 50000.0 ? "#,###.## \"kg\"" : "#,###.## \"l\""));
        exporter.setDateColumnFormat(dateColumn1, "dd/MM/yyyy");
        exporter.setDateColumnFormat(dateColumn2, (DateFormat)new SimpleDateFormat("dd/MM/yyyy"), "dd/MM/yyyy");
        exporter.setFileName("GridExport" + new SimpleDateFormat("yyyyddMM").format(Calendar.getInstance().getTime()));
        this.add(new Component[]{grid});
    }

    protected LocalDate createRandomDate(Faker faker) {
        return Instant.ofEpochMilli(faker.date().past(10000, TimeUnit.DAYS).getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

