/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.EncryptedDocumentException;

@DemoSource
@PageTitle(value="Multiple Header Rows")
@Route(value="gridexporter/headers", layout=GridExporterDemoView.class)
public class GridExporterMultipleHeaderRowsDemo
extends Div {
    private static final String NUMBER_FORMAT_PATTERN = "$#,###.##";
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    private static final String EXCEL_TEMPLATE_PATH = "/custom-template.xlsx";
    private static final String WORD_TEMPLATE_PATH = "/custom-template.docx";

    public GridExporterMultipleHeaderRowsDemo() throws EncryptedDocumentException, IOException {
        Grid grid = new Grid(Person.class);
        DecimalFormat decimalFormat = new DecimalFormat(NUMBER_FORMAT_PATTERN);
        grid.removeAllColumns();
        grid.addColumn((Renderer)LitRenderer.of((String)"<b>${item.name}</b>").withProperty("name", Person::getName)).setHeader("Name");
        grid.addColumn("lastName").setHeader("Last Name");
        grid.addColumn((ValueProvider & Serializable)item -> Faker.instance().lorem().characters(30, 50)).setHeader("Big column");
        Grid.Column budgetColumn = (Grid.Column)grid.addColumn((ValueProvider & Serializable)item -> decimalFormat.format(item.getBudget())).setHeader("Budget").setTextAlign(ColumnTextAlign.END);
        List people = IntStream.range(0, 100).asLongStream().mapToObj(number -> {
            Faker faker = new Faker();
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            return new Person(faker.name().firstName(), Math.random() > 0.3 ? faker.name().lastName() : null, faker.number().numberBetween(15, 50), budget);
        }).collect(Collectors.toList());
        BigDecimal total = people.stream().map(Person::getBudget).map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
        budgetColumn.setFooter(new DecimalFormat(NUMBER_FORMAT_PATTERN).format(total));
        grid.setItems(people);
        grid.setWidthFull();
        this.setSizeFull();
        HeaderRow firstExtraHeaderRow = grid.appendHeaderRow();
        HeaderRow secondExtraHeaderRow = grid.appendHeaderRow();
        for (Grid.Column column : grid.getColumns()) {
            String columnHeader = ((HeaderRow.HeaderCell)((HeaderRow)grid.getHeaderRows().get(0)).getCell(column)).getText();
            HeaderRow.HeaderCell firstHeaderCell = (HeaderRow.HeaderCell)firstExtraHeaderRow.getCell(column);
            firstHeaderCell.setComponent((Component)new Span(columnHeader + " 1"));
            HeaderRow.HeaderCell secondHeaderCell = (HeaderRow.HeaderCell)secondExtraHeaderRow.getCell(column);
            secondHeaderCell.setComponent((Component)new Span(columnHeader + " 2"));
        }
        GridExporter exporter = GridExporter.createFor((Grid)grid, (String)EXCEL_TEMPLATE_PATH, (String)WORD_TEMPLATE_PATH);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("${date}", new SimpleDateFormat(DATE_FORMAT_PATTERN).format(Calendar.getInstance().getTime()));
        exporter.setAdditionalPlaceHolders(placeholders);
        exporter.setSheetNumber(1);
        exporter.setCsvExportEnabled(false);
        exporter.setNumberColumnFormat(budgetColumn, decimalFormat, NUMBER_FORMAT_PATTERN);
        exporter.setTitle("People information");
        exporter.setNullValueHandler((SerializableSupplier & Serializable)() -> "(No lastname)");
        exporter.setFileName("GridExport" + new SimpleDateFormat(DATE_FORMAT_PATTERN).format(Calendar.getInstance().getTime()));
        this.add(new Component[]{grid});
    }
}

