/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.gridexporter.FakerInstance;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporterDemoView;
import com.flowingcode.vaadin.addons.gridexporter.Person;
import com.github.javafaker.Faker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.AbstractStreamResource;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.EncryptedDocumentException;

@DemoSource
@PageTitle(value="Custom Link")
@Route(value="gridexporter/custom-link", layout=GridExporterDemoView.class)
public class GridExporterCustomLinkDemo
extends Div {
    private static final Faker faker = FakerInstance.get();

    public GridExporterCustomLinkDemo() throws EncryptedDocumentException, IOException {
        Grid grid = new Grid(Person.class);
        grid.removeAllColumns();
        grid.addColumn("name").setHeader("Name");
        grid.addColumn("lastName").setHeader("Last Name");
        Grid.Column c = grid.addColumn((ValueProvider & Serializable)item -> "$" + item.getBudget()).setHeader("Budget");
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
        Stream<Person> stream = IntStream.range(0, 100).asLongStream().mapToObj(number -> {
            Double budget = faker.number().randomDouble(2, 10000, 100000);
            total[0] = total[0].add(BigDecimal.valueOf(budget));
            c.setFooter("$" + total[0]);
            return new Person(faker.name().firstName(), faker.name().lastName(), faker.number().numberBetween(15, 50), budget);
        });
        grid.setItems(DataProvider.fromStream(stream));
        grid.setWidthFull();
        this.setSizeFull();
        GridExporter exporter = GridExporter.createFor((Grid)grid);
        exporter.setAutoAttachExportButtons(false);
        exporter.setAutoSizeColumns(false);
        exporter.setTitle("People information");
        exporter.setFileName("GridExport" + new SimpleDateFormat("yyyyddMM").format(Calendar.getInstance().getTime()));
        Anchor excelLink = new Anchor("", "Export to Excel");
        excelLink.setHref((AbstractStreamResource)exporter.getExcelStreamResource());
        excelLink.getElement().setAttribute("download", true);
        this.add(new Component[]{grid, excelLink});
    }
}

