/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.DocxStreamResourceWriter;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.vaadin.flow.server.VaadinSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.docx4j.Docx4J;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfStreamResourceWriter<T>
extends DocxStreamResourceWriter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfStreamResourceWriter.class);

    public PdfStreamResourceWriter(GridExporter<T> exporter, String template) {
        super(exporter, template);
    }

    @Override
    public void accept(OutputStream out, VaadinSession session) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.createDoc(session).write((OutputStream)baos);
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
            Docx4J.toPDF((WordprocessingMLPackage)wordMLPackage, (OutputStream)out);
        }
        catch (Docx4JException e) {
            throw new RuntimeException("Problem when exporting data to PDF file", e);
        }
    }
}

