/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.DocxInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.docx4j.Docx4J;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfInputStreamFactory<T>
extends DocxInputStreamFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfInputStreamFactory.class);

    public PdfInputStreamFactory(GridExporter<T> exporter, String template) {
        super(exporter, template);
    }

    @Override
    public InputStream createInputStream() {
        PipedInputStream in = new PipedInputStream();
        try {
            final XWPFDocument doc = this.createDoc();
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        doc.write((OutputStream)baos);
                        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
                        Docx4J.toPDF((WordprocessingMLPackage)wordMLPackage, (OutputStream)out);
                    }
                    catch (IOException e) {
                        LOGGER.error("Problem generating export", (Throwable)e);
                    }
                    catch (Docx4JException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                LOGGER.error("Problem generating export", (Throwable)e);
                            }
                        }
                    }
                }
            }).start();
        }
        catch (IOException e) {
            LOGGER.error("Problem generating export", (Throwable)e);
        }
        return in;
    }
}

