/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.fontawesome.FontAwesome;
import com.flowingcode.vaadin.addons.gridexporter.CsvInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.DocxInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.ExcelInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.PdfInputStreamFactory;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.ColumnPathRenderer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridExporter<T>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelInputStreamFactory.class);
    private boolean excelExportEnabled = true;
    private boolean docxExportEnabled = true;
    private boolean pdfExportEnabled = true;
    private boolean csvExportEnabled = true;
    static final String COLUMN_VALUE_PROVIDER_DATA = "column-value-provider-data";
    static final String COLUMN_EXPORTED_PROVIDER_DATA = "column-value-exported-data";
    Grid<T> grid;
    String titlePlaceHolder = "${title}";
    String headersPlaceHolder = "${headers}";
    String dataPlaceHolder = "${data}";
    String footersPlaceHolder = "${footers}";
    Collection<Grid.Column<T>> columns;
    PropertySet<T> propertySet;
    Map<String, String> additionalPlaceHolders = new HashMap<String, String>();
    String title = "Grid Export";
    String fileName = "export";
    int sheetNumber = 0;
    boolean autoAttachExportButtons = true;
    boolean autoMergeTitle = true;
    public int totalcells = 0;

    private GridExporter(Grid<T> grid) {
        this.grid = grid;
    }

    public static <T> GridExporter<T> createFor(Grid<T> grid) {
        return GridExporter.createFor(grid, null, null);
    }

    public static <T> GridExporter<T> createFor(Grid<T> grid, String excelCustomTemplate, String docxCustomTemplate) {
        GridExporter exporter = new GridExporter(grid);
        grid.getElement().addAttachListener((ElementAttachListener & Serializable)ev -> {
            if (exporter.autoAttachExportButtons) {
                Anchor docLink;
                HorizontalLayout hl = new HorizontalLayout();
                if (exporter.isExcelExportEnabled()) {
                    Anchor excelLink = new Anchor("", new Component[]{FontAwesome.Regular.FILE_EXCEL.create()});
                    excelLink.setHref((AbstractStreamResource)exporter.getExcelStreamResource(excelCustomTemplate));
                    excelLink.getElement().setAttribute("download", true);
                    hl.add(new Component[]{excelLink});
                }
                if (exporter.isDocxExportEnabled()) {
                    docLink = new Anchor("", new Component[]{FontAwesome.Regular.FILE_WORD.create()});
                    docLink.setHref((AbstractStreamResource)exporter.getDocxStreamResource(docxCustomTemplate));
                    docLink.getElement().setAttribute("download", true);
                    hl.add(new Component[]{docLink});
                }
                if (exporter.isPdfExportEnabled()) {
                    docLink = new Anchor("", new Component[]{FontAwesome.Regular.FILE_PDF.create()});
                    docLink.setHref((AbstractStreamResource)exporter.getPdfStreamResource(docxCustomTemplate));
                    docLink.getElement().setAttribute("download", true);
                    hl.add(new Component[]{docLink});
                }
                if (exporter.isCsvExportEnabled()) {
                    Anchor csvLink = new Anchor("", new Component[]{FontAwesome.Regular.FILE_LINES.create()});
                    csvLink.setHref((AbstractStreamResource)exporter.getCsvStreamResource());
                    csvLink.getElement().setAttribute("download", true);
                    hl.add(new Component[]{csvLink});
                }
                hl.setSizeFull();
                hl.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
                GridHelper.addToolbarFooter((Grid)grid, (Component)hl);
            }
        });
        return exporter;
    }

    Object extractValueFromColumn(T item, Grid.Column<T> column) {
        ColumnPathRenderer r;
        Object value = null;
        ValueProvider customVP = (ValueProvider)ComponentUtil.getData(column, (String)COLUMN_VALUE_PROVIDER_DATA);
        if (customVP != null) {
            value = customVP.apply(item);
        }
        if (value == null && column.getKey() != null) {
            Optional propertyDefinition = this.propertySet.getProperty(column.getKey());
            if (propertyDefinition.isPresent()) {
                value = ((PropertyDefinition)propertyDefinition.get()).getGetter().apply(item);
            } else {
                LOGGER.warn("Column key: " + column.getKey() + " is a property which cannot be found");
            }
        }
        if (value == null && column.getRenderer() instanceof ColumnPathRenderer) {
            r = (ColumnPathRenderer)column.getRenderer();
            value = ((ValueProvider)r.getValueProviders().values().iterator().next()).apply(item);
        }
        if (value == null && column.getRenderer() instanceof LitRenderer && (r = (LitRenderer)column.getRenderer()).getValueProviders().values().size() == 1) {
            value = ((ValueProvider)r.getValueProviders().values().iterator().next()).apply(item);
        }
        if (value == null) {
            throw new IllegalStateException("It's not possible to obtain a value for column, please set a value provider by calling setExportValue()");
        }
        return value;
    }

    public StreamResource getDocxStreamResource() {
        return this.getDocxStreamResource(null);
    }

    public StreamResource getDocxStreamResource(String template) {
        return new StreamResource(this.fileName + ".docx", new DocxInputStreamFactory(this, template));
    }

    public StreamResource getPdfStreamResource() {
        return this.getPdfStreamResource(null);
    }

    public StreamResource getPdfStreamResource(String template) {
        return new StreamResource(this.fileName + ".pdf", new PdfInputStreamFactory(this, template));
    }

    public StreamResource getCsvStreamResource() {
        return new StreamResource(this.fileName + ".csv", new CsvInputStreamFactory(this));
    }

    public StreamResource getExcelStreamResource() {
        return this.getExcelStreamResource(null);
    }

    public StreamResource getExcelStreamResource(String template) {
        return new StreamResource(this.fileName + ".xlsx", new ExcelInputStreamFactory(this, template));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isAutoAttachExportButtons() {
        return this.autoAttachExportButtons;
    }

    public void setAutoAttachExportButtons(boolean autoAttachExportButtons) {
        this.autoAttachExportButtons = autoAttachExportButtons;
    }

    public Map<String, String> getAdditionalPlaceHolders() {
        return this.additionalPlaceHolders;
    }

    public void setAdditionalPlaceHolders(Map<String, String> additionalPlaceHolders) {
        this.additionalPlaceHolders = additionalPlaceHolders;
    }

    public int getSheetNumber() {
        return this.sheetNumber;
    }

    public void setSheetNumber(int sheetNumber) {
        this.sheetNumber = sheetNumber;
    }

    public boolean isAutoMergeTitle() {
        return this.autoMergeTitle;
    }

    public void setAutoMergeTitle(boolean autoMergeTitle) {
        this.autoMergeTitle = autoMergeTitle;
    }

    public boolean isExcelExportEnabled() {
        return this.excelExportEnabled;
    }

    public void setExcelExportEnabled(boolean excelExportEnabled) {
        this.excelExportEnabled = excelExportEnabled;
    }

    public boolean isDocxExportEnabled() {
        return this.docxExportEnabled;
    }

    public void setDocxExportEnabled(boolean docxExportEnabled) {
        this.docxExportEnabled = docxExportEnabled;
    }

    public boolean isPdfExportEnabled() {
        return this.pdfExportEnabled;
    }

    public void setPdfExportEnabled(boolean pdfExportEnabled) {
        this.pdfExportEnabled = pdfExportEnabled;
    }

    public boolean isCsvExportEnabled() {
        return this.csvExportEnabled;
    }

    public void setCsvExportEnabled(boolean csvExportEnabled) {
        this.csvExportEnabled = csvExportEnabled;
    }

    public void setExportValue(Grid.Column<T> column, ValueProvider<T, String> vp) {
        ComponentUtil.setData(column, (String)COLUMN_VALUE_PROVIDER_DATA, vp);
    }

    public void setExportColumn(Grid.Column<T> column, boolean export) {
        ComponentUtil.setData(column, (String)COLUMN_EXPORTED_PROVIDER_DATA, (Object)export);
    }
}

