/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.BaseInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.PoiHelper;
import com.vaadin.flow.component.grid.dataview.GridLazyDataView;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExcelInputStreamFactory<T>
extends BaseInputStreamFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelInputStreamFactory.class);
    private static final String DEFAULT_TEMPLATE = "/template.xlsx";

    public ExcelInputStreamFactory(GridExporter<T> exporter, String template) {
        super(exporter, template, DEFAULT_TEMPLATE);
    }

    public InputStream createInputStream() {
        PipedInputStream in = new PipedInputStream();
        try {
            this.exporter.columns = this.exporter.grid.getColumns().stream().filter(this::isExportable).collect(Collectors.toList());
            final Workbook wb = this.getBaseTemplateWorkbook();
            Sheet sheet = wb.getSheetAt(this.exporter.sheetNumber);
            Cell titleCell = this.findCellWithPlaceHolder(sheet, this.exporter.titlePlaceHolder);
            titleCell.setCellValue(this.exporter.title);
            Cell cell = this.findCellWithPlaceHolder(sheet, this.exporter.headersPlaceHolder);
            List<String> headers = this.getGridHeaders(this.exporter.grid);
            this.fillHeaderOrFooter(sheet, cell, headers);
            if (this.exporter.autoMergeTitle) {
                sheet.addMergedRegion(new CellRangeAddress(titleCell.getRowIndex(), titleCell.getRowIndex(), titleCell.getColumnIndex(), titleCell.getColumnIndex() + headers.size() - 1));
            }
            cell = this.findCellWithPlaceHolder(sheet, this.exporter.dataPlaceHolder);
            this.fillData(sheet, cell, this.exporter.grid.getDataProvider());
            cell = this.findCellWithPlaceHolder(sheet, this.exporter.footersPlaceHolder);
            List<String> footers = this.getGridFooters(this.exporter.grid);
            this.fillHeaderOrFooter(sheet, cell, footers);
            this.exporter.additionalPlaceHolders.entrySet().forEach(entry -> {
                Cell cellwp = this.findCellWithPlaceHolder(sheet, (String)entry.getKey());
                while (cellwp != null) {
                    cellwp.setCellValue((String)entry.getValue());
                    cellwp = this.findCellWithPlaceHolder(sheet, (String)entry.getKey());
                }
            });
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        wb.write((OutputStream)out);
                    }
                    catch (IOException e) {
                        LOGGER.error("Problem generating export", (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                LOGGER.error("Problem generating export", (Throwable)e);
                            }
                        }
                    }
                }
            }).start();
        }
        catch (IOException e) {
            LOGGER.error("Problem generating export", (Throwable)e);
        }
        return in;
    }

    private void fillData(Sheet sheet, Cell dataCell, DataProvider<T, ?> dataProvider) {
        Stream<Object> dataStream;
        Object filter = null;
        try {
            Method method = DataCommunicator.class.getDeclaredMethod("getFilter", new Class[0]);
            method.setAccessible(true);
            filter = method.invoke((Object)this.exporter.grid.getDataCommunicator(), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get filter from DataCommunicator", (Throwable)e);
        }
        if (dataProvider instanceof AbstractBackEndDataProvider) {
            GridLazyDataView gridLazyDataView = this.exporter.grid.getLazyDataView();
            dataStream = gridLazyDataView.getItems();
        } else {
            Query streamQuery = new Query(0, this.exporter.grid.getDataProvider().size(new Query(filter)), this.exporter.grid.getDataCommunicator().getBackEndSorting(), (Comparator)this.exporter.grid.getDataCommunicator().getInMemorySorting(), null);
            dataStream = this.getDataStream(streamQuery);
        }
        boolean[] notFirstRow = new boolean[1];
        Cell[] startingCell = new Cell[]{dataCell};
        dataStream.forEach(t -> {
            if (notFirstRow[0]) {
                CellStyle cellStyle = startingCell[0].getCellStyle();
                int lastRow = sheet.getLastRowNum();
                sheet.shiftRows(startingCell[0].getRowIndex() + 1, lastRow, 1);
                Row newRow = sheet.createRow(startingCell[0].getRowIndex() + 1);
                startingCell[0] = newRow.createCell(startingCell[0].getColumnIndex());
                startingCell[0].setCellStyle(cellStyle);
            }
            this.buildRow(t, sheet, startingCell[0]);
            notFirstRow[0] = true;
        });
    }

    private void buildRow(T item, Sheet sheet, Cell startingCell) {
        if (this.exporter.propertySet == null) {
            this.exporter.propertySet = BeanPropertySet.get(item.getClass());
        }
        if (this.exporter.columns.isEmpty()) {
            throw new IllegalStateException("Grid has no columns");
        }
        int[] currentColumn = new int[]{startingCell.getColumnIndex()};
        this.exporter.columns.forEach(column -> {
            Object value = this.exporter.extractValueFromColumn(item, column);
            Cell currentCell = startingCell;
            if (startingCell.getColumnIndex() < currentColumn[0]) {
                currentCell = startingCell.getRow().createCell(currentColumn[0]);
                currentCell.setCellStyle(startingCell.getCellStyle());
            }
            currentColumn[0] = currentColumn[0] + 1;
            this.buildCell(value, currentCell);
        });
    }

    private void buildCell(Object value, Cell cell) {
        if (value == null) {
            PoiHelper.setBlank(cell);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            cell.setCellValue(calendar.getTime());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }

    private Workbook getBaseTemplateWorkbook() {
        try {
            InputStream inp = this.getClass().getResourceAsStream(this.template);
            Workbook result = WorkbookFactory.create((InputStream)inp);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem creating workbook", e);
        }
    }

    private Cell findCellWithPlaceHolder(Sheet sheet, String placeholder) {
        for (Row row : sheet) {
            for (Cell cell : row) {
                if (!PoiHelper.cellTypeEquals(cell, CellType.STRING) || !cell.getRichStringCellValue().getString().trim().equals(placeholder)) continue;
                return cell;
            }
        }
        return null;
    }

    private void fillHeaderOrFooter(Sheet sheet, Cell headersCell, List<String> headers) {
        CellStyle style = headersCell.getCellStyle();
        sheet.setActiveCell(headersCell.getAddress());
        headers.forEach(header -> {
            Cell cell = sheet.getRow(sheet.getActiveCell().getRow()).getCell(sheet.getActiveCell().getColumn());
            if (cell == null) {
                cell = sheet.getRow(sheet.getActiveCell().getRow()).createCell(sheet.getActiveCell().getColumn());
                cell.setCellStyle(style);
            }
            cell.setCellValue(header);
            sheet.setActiveCell(new CellAddress(sheet.getActiveCell().getRow(), sheet.getActiveCell().getColumn() + 1));
        });
    }
}

