/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.BaseInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridexporter.PoiHelper;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocxInputStreamFactory<T>
extends BaseInputStreamFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocxInputStreamFactory.class);
    private static final String DEFAULT_TEMPLATE = "/template.docx";

    public DocxInputStreamFactory(GridExporter<T> exporter, String template) {
        super(exporter, template, DEFAULT_TEMPLATE);
    }

    public InputStream createInputStream() {
        PipedInputStream in = new PipedInputStream();
        try {
            final XWPFDocument doc = this.createDoc();
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        doc.write((OutputStream)out);
                    }
                    catch (IOException e) {
                        LOGGER.error("Problem generating export", (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                LOGGER.error("Problem generating export", (Throwable)e);
                            }
                        }
                    }
                }
            }).start();
        }
        catch (IOException e) {
            LOGGER.error("Problem generating export", (Throwable)e);
        }
        return in;
    }

    protected XWPFDocument createDoc() throws IOException {
        this.exporter.columns = this.exporter.grid.getColumns().stream().filter(this::isExportable).collect(Collectors.toList());
        XWPFDocument doc = this.getBaseTemplateDoc();
        doc.getParagraphs().forEach(paragraph -> paragraph.getRuns().forEach(run -> {
            String text = run.getText(0);
            if (text != null && text.contains(this.exporter.titlePlaceHolder)) {
                text = text.replace(this.exporter.titlePlaceHolder, this.exporter.title);
                run.setText(text, 0);
            }
            for (Map.Entry<String, String> entry : this.exporter.additionalPlaceHolders.entrySet()) {
                if (text == null || !text.contains(entry.getKey())) continue;
                text = text.replace(entry.getKey(), entry.getValue());
                run.setText(text, 0);
            }
        }));
        XWPFTable table = this.findTable(doc);
        PoiHelper.setWonCTTblWidth(table.getCTTbl().getTblPr().getTblW(), "9638");
        table.getCTTbl().getTblPr().getTblW().setType(STTblWidth.Enum.forString((String)"dxa"));
        table.getCTTbl().getTblGrid().getGridColList().clear();
        this.exporter.columns.forEach(col -> {
            CTTblGridCol cctblgridcol = table.getCTTbl().getTblGrid().addNewGridCol();
            PoiHelper.setWonCTTblGridCol(cctblgridcol, "" + Math.round(9638 / this.exporter.columns.size()));
        });
        List<String> headers = this.getGridHeaders(this.exporter.grid);
        XWPFTableCell cell = this.findCellWithPlaceHolder(table, this.exporter.headersPlaceHolder);
        this.fillHeaderOrFooter(table, cell, headers, true, this.exporter.headersPlaceHolder);
        cell = this.findCellWithPlaceHolder(table, this.exporter.dataPlaceHolder);
        this.fillData(table, cell, this.exporter.grid.getDataProvider());
        cell = this.findCellWithPlaceHolder(table, this.exporter.footersPlaceHolder);
        List<String> footers = this.getGridFooters(this.exporter.grid);
        this.fillHeaderOrFooter(table, cell, footers, false, this.exporter.footersPlaceHolder);
        return doc;
    }

    private void fillData(XWPFTable table, XWPFTableCell dataCell, DataProvider<T, ?> dataProvider) {
        Object filter = null;
        try {
            Method method = DataCommunicator.class.getDeclaredMethod("getFilter", new Class[0]);
            method.setAccessible(true);
            filter = method.invoke((Object)this.exporter.grid.getDataCommunicator(), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get filter from DataCommunicator", (Throwable)e);
        }
        Query streamQuery = new Query(0, this.exporter.grid.getDataProvider().size(new Query(filter)), this.exporter.grid.getDataCommunicator().getBackEndSorting(), (Comparator)this.exporter.grid.getDataCommunicator().getInMemorySorting(), null);
        Stream<Object> dataStream = this.getDataStream(streamQuery);
        boolean[] firstRow = new boolean[]{true};
        XWPFTableCell[] startingCell = new XWPFTableCell[]{dataCell};
        dataStream.forEach(t -> {
            XWPFTableRow currentRow = startingCell[0].getTableRow();
            if (!firstRow[0]) {
                currentRow = table.insertNewTableRow(dataCell.getTableRow().getTable().getRows().indexOf(dataCell.getTableRow()) + 1);
                Iterator iterator = this.exporter.columns.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    ++this.exporter.totalcells;
                    currentRow.createCell();
                }
                startingCell[0] = currentRow.getCell(0);
            }
            this.buildRow(t, currentRow, startingCell[0], dataCell.getCTTc().getTcPr(), dataCell);
            firstRow[0] = false;
        });
    }

    private void buildRow(T item, XWPFTableRow row, XWPFTableCell startingCell, CTTcPr tcpr, XWPFTableCell templateCell) {
        if (this.exporter.propertySet == null) {
            this.exporter.propertySet = BeanPropertySet.get(item.getClass());
        }
        if (this.exporter.columns.isEmpty()) {
            throw new IllegalStateException("Grid has no columns");
        }
        int[] currentColumn = new int[]{row.getTableCells().indexOf(startingCell)};
        this.exporter.columns.forEach(column -> {
            Object value = this.exporter.extractValueFromColumn(item, column);
            XWPFTableCell currentCell = startingCell;
            if (row.getTableCells().indexOf(startingCell) < currentColumn[0] && (currentCell = startingCell.getTableRow().getCell(currentColumn[0])) == null) {
                currentCell = startingCell.getTableRow().createCell();
            }
            PoiHelper.setWidth(currentCell, "" + Math.round(9638 / this.exporter.columns.size()));
            currentCell.getCTTc().setTcPr(tcpr);
            currentColumn[0] = currentColumn[0] + 1;
            this.buildCell(value, currentCell, ((XWPFParagraph)templateCell.getParagraphs().iterator().next()).getCTP().getPPr(), ((XWPFRun)((XWPFParagraph)templateCell.getParagraphs().iterator().next()).getRuns().iterator().next()).getCTR().getRPr());
        });
    }

    private void buildCell(Object value, XWPFTableCell cell, CTPPr ctpPr, CTRPr ctrPr) {
        if (value == null) {
            this.setCellValue("", cell, this.exporter.dataPlaceHolder, ctpPr, ctrPr);
        } else if (value instanceof Boolean) {
            this.setCellValue("" + (Boolean)value, cell, this.exporter.dataPlaceHolder, ctpPr, ctrPr);
        } else if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            this.setCellValue("" + calendar.getTime(), cell, this.exporter.dataPlaceHolder, ctpPr, ctrPr);
        } else if (value instanceof Double) {
            this.setCellValue("" + (Double)value, cell, this.exporter.dataPlaceHolder, ctpPr, ctrPr);
        } else {
            this.setCellValue(value.toString(), cell, this.exporter.dataPlaceHolder, ctpPr, ctrPr);
        }
    }

    private void setCellValue(String value, XWPFTableCell cell, String placeHolderToReplace) {
        this.setCellValue(value, cell, placeHolderToReplace, null, null);
    }

    private void setCellValue(String value, XWPFTableCell cell, String placeHolderToReplace, CTPPr ctpPr, CTRPr ctrPr) {
        XWPFParagraph p = (XWPFParagraph)cell.getParagraphs().get(0);
        if (ctpPr != null) {
            p.getCTP().setPPr(ctpPr);
        }
        if (p.getRuns().size() == 0) {
            XWPFRun run2 = p.createRun();
            if (ctrPr != null) {
                run2.getCTR().setRPr(ctrPr);
            }
            run2.setText(value);
        } else {
            p.getRuns().forEach(run -> {
                String text = run.getText(0);
                text = text.indexOf(placeHolderToReplace) > 0 ? text.replace(placeHolderToReplace, value) : value;
                run.setText(text, 0);
            });
        }
        p.setStyle("TextBody");
    }

    private void fillHeaderOrFooter(XWPFTable table, XWPFTableCell cell, List<String> headers, boolean createColumns, String placeHolder) {
        boolean[] firstHeader = new boolean[]{true};
        XWPFTableRow tableRow = cell.getTableRow();
        headers.forEach(header -> {
            if (!firstHeader[0]) {
                XWPFTableCell currentCell = tableRow.addNewTableCell();
                currentCell.getCTTc().setTcPr(cell.getCTTc().getTcPr());
                PoiHelper.setWidth(currentCell, "" + Math.round(9638 / this.exporter.columns.size()));
                this.setCellValue((String)header, currentCell, placeHolder, ((XWPFParagraph)cell.getParagraphs().iterator().next()).getCTP().getPPr(), ((XWPFRun)((XWPFParagraph)cell.getParagraphs().iterator().next()).getRuns().iterator().next()).getCTR().getRPr());
            } else {
                this.setCellValue((String)header, cell, placeHolder);
                PoiHelper.setWidth(cell, "" + Math.round(9638 / this.exporter.columns.size()));
                firstHeader[0] = false;
            }
        });
    }

    private XWPFTableCell findCellWithPlaceHolder(XWPFTable table, String placeHolder) {
        for (XWPFTableRow row : table.getRows()) {
            for (XWPFTableCell cell : row.getTableCells()) {
                if (!cell.getText().equals(placeHolder)) continue;
                return cell;
            }
        }
        return null;
    }

    private XWPFTable findTable(XWPFDocument doc) {
        XWPFTable[] result = new XWPFTable[1];
        doc.getTables().forEach(table -> {
            boolean[] foundHeaders = new boolean[1];
            boolean[] foundData = new boolean[1];
            table.getRows().forEach(row -> {
                XWPFTableCell cell = row.getCell(0);
                if (cell.getText().equals(this.exporter.headersPlaceHolder)) {
                    foundHeaders[0] = true;
                }
                if (cell.getText().equals(this.exporter.dataPlaceHolder)) {
                    foundData[0] = true;
                }
            });
            if (foundHeaders[0] && foundData[0]) {
                result[0] = table;
            }
        });
        return result[0];
    }

    private XWPFDocument getBaseTemplateDoc() throws EncryptedDocumentException, IOException {
        InputStream inp = this.getClass().getResourceAsStream(this.template);
        return new XWPFDocument(inp);
    }
}

