/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.BaseInputStreamFactory;
import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.opencsv.CSVWriter;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.Query;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CsvInputStreamFactory<T>
extends BaseInputStreamFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvInputStreamFactory.class);

    public CsvInputStreamFactory(GridExporter<T> exporter) {
        super(exporter, null, null);
    }

    public InputStream createInputStream() {
        PipedInputStream in = new PipedInputStream();
        try {
            this.exporter.columns = this.exporter.grid.getColumns().stream().filter(this::isExportable).collect(Collectors.toList());
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(out));
                        List<String> headers = CsvInputStreamFactory.this.getGridHeaders(CsvInputStreamFactory.this.exporter.grid);
                        writer.writeNext(headers.toArray(new String[0]));
                        Object filter = null;
                        try {
                            Method method = DataCommunicator.class.getDeclaredMethod("getFilter", new Class[0]);
                            method.setAccessible(true);
                            filter = method.invoke((Object)CsvInputStreamFactory.this.exporter.grid.getDataCommunicator(), new Object[0]);
                        }
                        catch (Exception e) {
                            LOGGER.error("Unable to get filter from DataCommunicator", (Throwable)e);
                        }
                        Query streamQuery = new Query(0, CsvInputStreamFactory.this.exporter.grid.getDataProvider().size(new Query(filter)), CsvInputStreamFactory.this.exporter.grid.getDataCommunicator().getBackEndSorting(), (Comparator)CsvInputStreamFactory.this.exporter.grid.getDataCommunicator().getInMemorySorting(), null);
                        Stream<Object> dataStream = CsvInputStreamFactory.this.getDataStream(streamQuery);
                        dataStream.forEach(t -> writer.writeNext(CsvInputStreamFactory.this.buildRow(t, writer)));
                        List<String> footers = CsvInputStreamFactory.this.getGridFooters(CsvInputStreamFactory.this.exporter.grid);
                        writer.writeNext(footers.toArray(new String[0]));
                        writer.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Problem generating export", (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                LOGGER.error("Problem generating export", (Throwable)e);
                            }
                        }
                    }
                }
            }).start();
        }
        catch (IOException e) {
            LOGGER.error("Problem generating export", (Throwable)e);
        }
        return in;
    }

    private String[] buildRow(T item, CSVWriter writer) {
        if (this.exporter.propertySet == null) {
            this.exporter.propertySet = BeanPropertySet.get(item.getClass());
        }
        if (this.exporter.columns.isEmpty()) {
            throw new IllegalStateException("Grid has no columns");
        }
        String[] result = new String[this.exporter.columns.size()];
        int[] currentColumn = new int[1];
        this.exporter.columns.forEach(column -> {
            Object value = this.exporter.extractValueFromColumn(item, column);
            result[currentColumn[0]] = "" + value;
            currentColumn[0] = currentColumn[0] + 1;
        });
        return result;
    }
}

