/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.gridexporter;

import com.flowingcode.vaadin.addons.gridexporter.GridExporter;
import com.flowingcode.vaadin.addons.gridhelpers.GridHelper;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.server.InputStreamFactory;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

abstract class BaseInputStreamFactory<T>
implements InputStreamFactory {
    protected GridExporter<T> exporter;
    protected String template;

    public BaseInputStreamFactory(GridExporter<T> exporter) {
        this.exporter = exporter;
    }

    public BaseInputStreamFactory(GridExporter<T> exporter, String customTemplate, String defaultTemplate) {
        this.exporter = exporter;
        this.template = customTemplate == null ? defaultTemplate : customTemplate;
    }

    protected boolean isExportable(Grid.Column<T> column) {
        Boolean exported = (Boolean)ComponentUtil.getData(column, (String)"column-value-exported-data");
        return exported != null ? exported.booleanValue() : column.isVisible();
    }

    protected Stream<T> getDataStream(Query newQuery) {
        Stream stream = this.exporter.grid.getDataProvider().fetch(newQuery);
        if (stream.isParallel()) {
            LoggerFactory.getLogger(DataCommunicator.class).debug("Data provider {} has returned parallel stream on 'fetch' call", this.exporter.grid.getDataProvider().getClass());
            stream = stream.collect(Collectors.toList()).stream();
            assert (!stream.isParallel());
        }
        return stream;
    }

    protected List<String> getGridHeaders(Grid<T> grid) {
        return this.exporter.columns.stream().map(column -> GridHelper.getHeader((Grid)grid, (Grid.Column)column)).collect(Collectors.toList());
    }

    protected List<String> getGridFooters(Grid<T> grid) {
        return this.exporter.columns.stream().map(column -> GridHelper.getFooter((Grid)grid, (Grid.Column)column)).collect(Collectors.toList());
    }
}

