/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.githubbuttons;

import com.flowingcode.vaadin.addons.githubbuttons.BaseGitHubButton;
import com.flowingcode.vaadin.addons.githubbuttons.SizeableGitHubButton;
import com.flowingcode.vaadin.addons.githubbuttons.enums.ButtonSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import java.io.Serializable;
import java.util.Arrays;

public class DemoUtils {
    public static Html getDemoTitle(String repo, String user) {
        String repoString = "Repo: " + repo;
        String userString = "User: " + user;
        return new Html("<h4>" + repoString + "<br>" + userString + "</h4>");
    }

    public static Checkbox getCountCheckbox(BaseGitHubButton button) {
        Checkbox countCheckbox = new Checkbox("Show Count");
        countCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> button.setCount(((Boolean)e.getValue()).booleanValue()));
        countCheckbox.setValue((Object)button.isCount());
        return countCheckbox;
    }

    public static ComboBox<String> getTargetComboBox(BaseGitHubButton button) {
        ComboBox targetComboBox = new ComboBox("Select Target");
        targetComboBox.setItems(Arrays.asList("_self", "_blank"));
        targetComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> button.setTarget((String)e.getValue()));
        targetComboBox.setValue((Object)button.getTarget());
        return targetComboBox;
    }

    public static Checkbox getSizeCheckbox(SizeableGitHubButton button) {
        Checkbox sizeCheckbox = new Checkbox("Large Size");
        sizeCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> button.setSize((Boolean)e.getValue() != false ? ButtonSize.LARGE : ButtonSize.NONE));
        sizeCheckbox.setValue((Object)ButtonSize.LARGE.equals((Object)button.getSize()));
        return sizeCheckbox;
    }
}

