/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.flipcard;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Element;

@NpmPackage(value="flip-card-wc", version="1.3.0")
@JsModule(value="flip-card-wc/dist/flip-card-wc.js")
@Tag(value="flip-card")
public class FlipCard
extends Div {
    public FlipCard(Component frontComponent, Component backComponent) {
        this.setFrontComponent(frontComponent);
        this.setBackComponent(backComponent);
    }

    public FlipCard(Component frontComponent, Component backComponent, FlipCardVariant variant) {
        this(frontComponent, backComponent);
        this.setVariant(variant);
    }

    public void setVariant(FlipCardVariant variant) {
        this.getElement().setProperty("variant", variant.name().toLowerCase());
    }

    public FlipCardVariant getVariant() {
        return FlipCardVariant.valueOf(this.getElement().getProperty("variant", FlipCardVariant.HOVER.name()).toUpperCase());
    }

    public void setFrontComponent(Component component) {
        Element frontElement = component.getElement();
        frontElement.setAttribute("slot", "front");
        this.getElement().appendChild(new Element[]{frontElement});
    }

    public void setBackComponent(Component component) {
        Element backElement = component.getElement();
        backElement.setAttribute("slot", "back");
        this.getElement().appendChild(new Element[]{backElement});
    }

    public static enum FlipCardVariant {
        HOVER,
        CLICK;

    }
}

