/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import com.flowingcode.vaadin.addons.chatassistant.model.Message;
import com.flowingcode.vaadin.addons.markdown.MarkdownViewer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import lombok.Generated;

@JsModule(value="@vaadin/message-list/src/vaadin-message.js")
@Tag(value="vaadin-message")
@CssImport(value="./styles/chat-message-styles.css")
public class ChatMessage<T extends Message>
extends Component
implements HasComponents {
    private T message;
    private boolean markdownEnabled;
    private Div loader;
    private MarkdownViewer markdownViewer;

    public ChatMessage(T message) {
        this(message, false);
    }

    public ChatMessage(T message, boolean markdownEnabled) {
        this.markdownEnabled = markdownEnabled;
        this.loader = new Div(new Component[]{new Div(), new Div(), new Div(), new Div()});
        this.loader.setClassName("lds-ellipsis");
        this.loader.setVisible(false);
        this.add(new Component[]{this.loader});
        if (markdownEnabled) {
            this.markdownViewer = new MarkdownViewer(((Message)message).getContent());
            this.add(new Component[]{this.markdownViewer});
        }
        this.setMessage(message);
    }

    public void setMessage(T message) {
        this.message = message;
        this.updateMessage(message);
        if (((Message)message).getName() != null) {
            this.setUserName(((Message)message).getName());
            if (((Message)message).getAvatar() != null) {
                this.setUserImg(((Message)message).getAvatar());
            }
        }
        if (((Message)message).getMessageTime() != null) {
            String formattedTime = ((Message)message).getMessageTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            this.setTime(formattedTime);
        }
    }

    private void updateMessage(T message) {
        this.loader.setVisible(((Message)message).isLoading());
        if (!((Message)message).isLoading()) {
            if (this.markdownEnabled) {
                this.markdownViewer.setContent(((Message)message).getContent());
            } else {
                this.getElement().executeJs("[...this.childNodes].forEach(node => node.nodeType === 3 && this.removeChild(node));", new Serializable[0]);
                this.getElement().executeJs("this.appendChild(document.createTextNode($0));", new Serializable[]{((Message)message).getContent()});
            }
        }
    }

    public T getMessage() {
        return this.message;
    }

    private void setUserName(String username) {
        this.getElement().setAttribute("user-name", username);
    }

    private void setUserImg(String imageUrl) {
        this.getElement().setAttribute("user-img", imageUrl);
    }

    private void setTime(String time) {
        this.getElement().setAttribute("time", time);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.markdownEnabled != other.markdownEnabled) {
            return false;
        }
        T this$message = this.getMessage();
        T other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Div this$loader = this.loader;
        Div other$loader = other.loader;
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        MarkdownViewer this$markdownViewer = this.markdownViewer;
        MarkdownViewer other$markdownViewer = other.markdownViewer;
        return !(this$markdownViewer == null ? other$markdownViewer != null : !this$markdownViewer.equals(other$markdownViewer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.markdownEnabled ? 79 : 97);
        T $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Div $loader = this.loader;
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        MarkdownViewer $markdownViewer = this.markdownViewer;
        result = result * 59 + ($markdownViewer == null ? 43 : $markdownViewer.hashCode());
        return result;
    }
}

