/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import com.flowingcode.vaadin.addons.chatassistant.ChatAssistant;
import com.flowingcode.vaadin.addons.chatassistant.ChatAssistantDemoView;
import com.flowingcode.vaadin.addons.chatassistant.CustomChatMessage;
import com.flowingcode.vaadin.addons.chatassistant.CustomMessage;
import com.flowingcode.vaadin.addons.chatassistant.model.Message;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.SourcePosition;
import com.google.common.base.Strings;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

@DemoSource(sourcePosition=SourcePosition.PRIMARY)
@PageTitle(value="Generative Answer Demo")
@Route(value="chat-assistant/generative-demo", layout=ChatAssistantDemoView.class)
@CssImport(value="./styles/chat-assistant-styles-demo.css")
public class ChatAssistantGenerativeDemo
extends VerticalLayout {
    public ChatAssistantGenerativeDemo() {
        String sampleText = "Hi, I'm an advanced language model. I'm here to help you demonstrate how a text-streaming chat component works in Vaadin. As you can see, each word appears with a slight pause, simulating the time it would take me to \"think\" and generate the next word. I hope this is useful for your demonstration!";
        ChatAssistant chatAssistant = new ChatAssistant();
        chatAssistant.setAvatarProvider((SerializableSupplier & Serializable)() -> new Avatar("Chat Assistant", "chatbot.png"));
        TextArea message = new TextArea();
        message.setLabel("Enter a message from the assistant");
        message.setSizeFull();
        message.setValue(sampleText);
        message.addKeyPressListener((ComponentEventListener & Serializable)ev -> {
            if (Strings.isNullOrEmpty((String)chatAssistant.getWhoIsTyping())) {
                chatAssistant.setWhoIsTyping("Assistant is generating an answer ...");
            }
        });
        message.addBlurListener((ComponentEventListener & Serializable)ev -> chatAssistant.clearWhoIsTyping());
        chatAssistant.setMessagesRenderer((Renderer)new ComponentRenderer((SerializableFunction & Serializable)m -> new CustomChatMessage((CustomMessage)((Object)((Object)m))), (SerializableBiFunction & Serializable)(component, m) -> {
            ((CustomChatMessage)((Object)((Object)component))).setMessage((Message)m);
            return component;
        }));
        chatAssistant.setSubmitListener((ComponentEventListener & Serializable)se -> chatAssistant.sendMessage(((CustomMessage.CustomMessageBuilder)((Object)((Object)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)CustomMessage.builder().messageTime(LocalDateTime.now())).name("User")).content(se.getValue())).tagline("Generated by user")))).build()));
        Button chat = new Button("Chat");
        chat.addClickListener((ComponentEventListener & Serializable)ev -> {
            Message m = ((CustomMessage.CustomMessageBuilder)((Object)((Object)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)CustomMessage.builder().content(message.getValue())).messageTime(LocalDateTime.now())).name("Assistant")).avatar("chatbot.png")).tagline("Generated by assistant")))).build();
            chatAssistant.sendMessage(m);
            message.clear();
        });
        Button chatWithThinking = new Button("Chat With Generative Thinking");
        chatWithThinking.addClickListener((ComponentEventListener & Serializable)ev -> {
            String messageToSend = message.getValue();
            Message delayedMessage = ((CustomMessage.CustomMessageBuilder)((Object)((Object)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)CustomMessage.builder().loading(true)).content("")).messageTime(LocalDateTime.now())).name("Assistant")).avatar("chatbot.png")).tagline("Generated by assistant")))).build();
            UI currentUI = UI.getCurrent();
            chatAssistant.sendMessage(delayedMessage);
            CompletableFuture.runAsync(() -> this.lambda$new$1(currentUI, (CustomMessage)delayedMessage, messageToSend, chatAssistant));
            message.clear();
        });
        chatAssistant.sendMessage(((CustomMessage.CustomMessageBuilder)((Object)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)((CustomMessage.CustomMessageBuilder)CustomMessage.builder().content("Hello, I am here to assist you")).messageTime(LocalDateTime.now())).name("Assistant")).avatar("chatbot.png")).tagline("Generated by assistant"))).build());
        this.add(new Component[]{message, chat, chatWithThinking, chatAssistant});
    }

    public Stream<String> streamWords(String fullText) {
        if (fullText == null || fullText.isEmpty()) {
            return Stream.empty();
        }
        String[] words = fullText.split("\\s+");
        return Arrays.stream(words).map(word -> {
            try {
                long delay = ThreadLocalRandom.current().nextLong(50L, 250L);
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return word + " ";
        });
    }

    private /* synthetic */ void lambda$new$1(UI currentUI, CustomMessage delayedMessage, String messageToSend, ChatAssistant chatAssistant) {
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
            currentUI.access((Command & Serializable)() -> delayedMessage.setLoading(false));
            this.streamWords(messageToSend).forEach(item -> currentUI.access((Command & Serializable)() -> {
                delayedMessage.setContent(delayedMessage.getContent() + item);
                chatAssistant.updateMessage((Message)delayedMessage);
            }));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

