/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import com.flowingcode.vaadin.addons.chatassistant.ChatAssistant;
import com.flowingcode.vaadin.addons.chatassistant.ChatAssistantDemoView;
import com.flowingcode.vaadin.addons.chatassistant.model.Message;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.SourcePosition;
import com.google.common.base.Strings;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.time.LocalDateTime;

@DemoSource(sourcePosition=SourcePosition.PRIMARY)
@PageTitle(value="Markdown Demo")
@Route(value="chat-assistant/markdown-demo", layout=ChatAssistantDemoView.class)
@CssImport(value="./styles/chat-assistant-styles-demo.css")
public class ChatAssistantMarkdownDemo
extends VerticalLayout {
    public ChatAssistantMarkdownDemo() {
        ChatAssistant chatAssistant = new ChatAssistant(true);
        TextArea message = new TextArea();
        message.setLabel("Enter a message from the assistant (try using Markdown)");
        message.setSizeFull();
        message.addKeyPressListener((ComponentEventListener & Serializable)ev -> {
            if (Strings.isNullOrEmpty((String)chatAssistant.getWhoIsTyping())) {
                chatAssistant.setWhoIsTyping("Assistant is generating an answer ...");
            }
        });
        message.addBlurListener((ComponentEventListener & Serializable)ev -> chatAssistant.clearWhoIsTyping());
        Button chat = new Button("Chat");
        chat.addClickListener((ComponentEventListener & Serializable)ev -> {
            Message m = Message.builder().content(message.getValue()).messageTime(LocalDateTime.now()).name("Assistant").avatar("chatbot.png").build();
            chatAssistant.sendMessage(m);
            message.clear();
        });
        chatAssistant.sendMessage(Message.builder().content("**Hello, I am here to assist you**").messageTime(LocalDateTime.now()).name("Assistant").avatar("chatbot.png").build());
        this.add(new Component[]{message, chat, chatAssistant});
    }
}

