/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import com.flowingcode.vaadin.addons.chatassistant.ChatAssistant;
import com.flowingcode.vaadin.addons.chatassistant.ChatAssistantDemoView;
import com.flowingcode.vaadin.addons.chatassistant.model.Message;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.SourcePosition;
import com.google.common.base.Strings;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.messages.MessageInput;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@DemoSource(sourcePosition=SourcePosition.PRIMARY)
@PageTitle(value="Lazy Loading Demo")
@Route(value="chat-assistant/lazy-loading-demo", layout=ChatAssistantDemoView.class)
@CssImport(value="./styles/chat-assistant-styles-demo.css")
public class ChatAssistantLazyLoadingDemo
extends VerticalLayout {
    List<Message> messages = new ArrayList<Message>(Arrays.asList(Message.builder().name("Claudius").content("I have sent to seek him and to find the body.\nHow dangerous is it that this man goes loose!\nYet must not we put the strong law on him.\nHe's loved of the distracted multitude,\nWho like not in their judgment, but their eyes.\nAnd where 'tis so, th' offender's scourge is weighed,\nBut never the offense. To bear all smooth and even,\nThis sudden sending him away must seem\nDeliberate pause. Diseases desperate grown\nBy desperate appliance are relieved,\nOr not at all.").build(), Message.builder().name("Rosencrantz").content("(Enter)").build(), Message.builder().name("Claudius").content("How now, what hath befall'n?").build(), Message.builder().name("Rosencrantz").content("Where the dead body is bestowed, my lord,\nWe cannot get from him.").build(), Message.builder().name("Claudius").content("But where is he?").build(), Message.builder().name("Rosencrantz").content("Without, my lord; guarded, to know your pleasure.").build(), Message.builder().name("Claudius").content("Bring him before us.").build(), Message.builder().name("Rosencrantz").content("Ho, Guildenstern! Bring in my lord.").build(), Message.builder().name("Claudius").content("Now, Hamlet, where's Polonius?").build(), Message.builder().name("Hamlet").content("At supper.").build(), Message.builder().name("Claudius").content("At supper? Where? ").build(), Message.builder().name("Hamlet").content("Not where he eats, but where he is eaten. A certain \nconvocation of politic worms are e'en at him. Your worm is your \nonly emperor for diet. We fat all creatures else to fat us, and \nwe fat ourselves for maggots. Your fat king and your lean beggar \nis but variable service- two dishes, but to one table. That's the \nend.").build(), Message.builder().name("Claudius").content("Alas, alas!").build(), Message.builder().name("Hamlet").content("A man may fish with the worm that hath eat of a king, and eat \nof the fish that hath fed of that worm.").build(), Message.builder().name("Claudius").content("What dost thou mean by this?").build(), Message.builder().name("Hamlet").content("Nothing but to show you how a king may go a progress through \nthe guts of a beggar.\n").build(), Message.builder().name("Claudius").content("Where is Polonius?").build(), Message.builder().name("Hamlet").content("In heaven. Send thither to see. If your messenger find him not \nthere, seek him i' th' other place yourself. But indeed, if you\nfind him not within this month, you shall nose him as you go up \nthe stair, into the lobby.").build(), Message.builder().name("Claudius").content("Go seek him there.").build(), Message.builder().name("Hamlet").content("He will stay till you come.").build(), Message.builder().name("Claudius").content("Hamlet, this deed, for thine especial safety,- \nWhich we do tender as we dearly grieve \nFor that which thou hast done,- must send thee hence \nWith fiery quickness. Therefore prepare thyself. \nThe bark is ready and the wind at help, \nTh' associates tend, and everything is bent \nFor England.").build(), Message.builder().name("Hamlet").content("For England?").build(), Message.builder().name("Claudius").content("Ay, Hamlet.").build(), Message.builder().name("Hamlet").content("Good.").build(), Message.builder().name("Claudius").content("So is it, if thou knew'st our purposes.").build(), Message.builder().name("Hamlet").content("I see a cherub that sees them. But come, for England! \nFarewell, dear mother.").build(), Message.builder().name("Claudius").content("Thy loving father, Hamlet.").build(), Message.builder().name("Hamlet").content("My mother! Father and mother is man and wife; man and wife is\none flesh; and so, my mother. Come, for England!").build(), Message.builder().name("Claudius").content("Follow him at foot; tempt him with speed aboard. \nDelay it not; I'll have him hence to-night. \nAway! for everything is seal'd and done\nThat else leans on th' affair. Pray you make haste.").build(), Message.builder().name("Claudius").content("And, England, if my love thou hold'st at aught,- \nAs my great power thereof may give thee sense, \nSince yet thy cicatrice looks raw and red\nAfter the Danish sword, and thy free awe \nPays homage to us,- thou mayst not coldly set \nOur sovereign process, which imports at full, \nBy letters congruing to that effect, \nThe present death of Hamlet. Do it, England; \nFor like the hectic in my blood he rages, \nAnd thou must cure me. Till I know 'tis done, \nHowe'er my haps, my joys were ne'er begun. ").build()));

    public ChatAssistantLazyLoadingDemo() {
        ChatAssistant chatAssistant = new ChatAssistant();
        chatAssistant.setClassName("small");
        Span lazyLoadingData = new Span();
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            lazyLoadingData.setText("Loading messages from: " + query.getOffset() + ", with limit: " + query.getLimit());
            return this.messages.stream().skip(query.getOffset()).limit(query.getLimit());
        }, (CallbackDataProvider.CountCallback & Serializable)query -> this.messages.size());
        chatAssistant.setDataProvider((DataProvider)dataProvider);
        TextArea message = new TextArea();
        message.setLabel("Enter a message from the assistant");
        message.setSizeFull();
        message.addKeyPressListener((ComponentEventListener & Serializable)ev -> {
            if (Strings.isNullOrEmpty((String)chatAssistant.getWhoIsTyping())) {
                chatAssistant.setWhoIsTyping("Assistant is generating an answer ...");
            }
        });
        message.addBlurListener((ComponentEventListener & Serializable)ev -> chatAssistant.clearWhoIsTyping());
        Button chat = new Button("Chat");
        chat.addClickListener(arg_0 -> this.lambda$new$4a0371a6$1(message, (DataProvider)dataProvider, chatAssistant, arg_0));
        chatAssistant.setSubmitListener(arg_0 -> this.lambda$new$32c3c5d$1((DataProvider)dataProvider, chatAssistant, arg_0));
        Icon minimize = VaadinIcon.MINUS.create();
        minimize.addClickListener((ComponentEventListener & Serializable)ev -> chatAssistant.setMinimized(!chatAssistant.isMinimized()));
        Span title = new Span("Customized Assistant Header");
        title.setWidthFull();
        HorizontalLayout headerBar = new HorizontalLayout(new Component[]{title, minimize});
        headerBar.setWidthFull();
        chatAssistant.setHeaderComponent((Component)headerBar);
        this.add(new Component[]{message, lazyLoadingData, chat, chatAssistant});
    }

    private /* synthetic */ void lambda$new$32c3c5d$1(DataProvider dataProvider, ChatAssistant chatAssistant, MessageInput.SubmitEvent ev) {
        Message userMessage = Message.builder().messageTime(LocalDateTime.now()).name("User").content(ev.getValue()).build();
        this.messages.add(userMessage);
        dataProvider.refreshAll();
        chatAssistant.scrollToEnd();
    }

    private /* synthetic */ void lambda$new$4a0371a6$1(TextArea message, DataProvider dataProvider, ChatAssistant chatAssistant, ClickEvent ev) {
        Message m = Message.builder().content(message.getValue()).messageTime(LocalDateTime.now()).name("Assistant").avatar("chatbot.png").build();
        this.messages.add(m);
        dataProvider.refreshAll();
        chatAssistant.scrollToEnd();
        message.clear();
    }
}

