/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import com.flowingcode.vaadin.addons.chatassistant.model.Message;
import com.flowingcode.vaadin.addons.markdown.BaseMarkdownComponent;
import com.flowingcode.vaadin.addons.markdown.MarkdownViewer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import lombok.Generated;

@JsModule(value="@vaadin/message-list/src/vaadin-message.js")
@Tag(value="vaadin-message")
@CssImport(value="./styles/chat-message-styles.css")
public class ChatMessage
extends Component
implements HasComponents {
    private Message message;
    private boolean markdownEnabled;
    private Div loader;

    public ChatMessage(Message message) {
        this(message, false);
    }

    public ChatMessage(Message message, boolean markdownEnabled) {
        this.markdownEnabled = markdownEnabled;
        this.setMessage(message);
    }

    public void setMessage(Message message) {
        this.message = message;
        this.updateLoadingState(message);
        if (message.getName() != null) {
            this.setUserName(message.getName());
            if (message.getAvatar() != null) {
                this.setUserImg(message.getAvatar());
            }
        }
        if (message.getMessageTime() != null) {
            String formattedTime = message.getMessageTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            this.setTime(formattedTime);
        }
    }

    private void updateLoadingState(Message message) {
        if (message.isLoading()) {
            this.loader = new Div(new Component[]{new Div(), new Div(), new Div(), new Div()});
            this.loader.setClassName("lds-ellipsis");
            this.add(new Component[]{this.loader});
        } else {
            if (this.loader != null) {
                this.remove(new Component[]{this.loader});
                this.loader = null;
            }
            if (this.markdownEnabled) {
                MarkdownViewer mdv = new MarkdownViewer(message.getContent());
                mdv.setDataColorMode(BaseMarkdownComponent.DataColorMode.LIGHT);
                this.add(new Component[]{mdv});
            } else {
                this.getElement().executeJs("this.appendChild(document.createTextNode($0));", new Serializable[]{message.getContent()});
            }
        }
    }

    public Message getMessage() {
        return this.message;
    }

    private void setUserName(String username) {
        this.getElement().setAttribute("user-name", username);
    }

    private void setUserImg(String imageUrl) {
        this.getElement().setAttribute("user-img", imageUrl);
    }

    private void setTime(String time) {
        this.getElement().setAttribute("time", time);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.markdownEnabled != other.markdownEnabled) {
            return false;
        }
        Message this$message = this.getMessage();
        Message other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Div this$loader = this.loader;
        Div other$loader = other.loader;
        return !(this$loader == null ? other$loader != null : !this$loader.equals(other$loader));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.markdownEnabled ? 79 : 97);
        Message $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Div $loader = this.loader;
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        return result;
    }
}

