/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;

public class Sender {
    private String name;
    private String id;
    private String avatar;

    public JsonValue getJsonObject() {
        JsonObject result = Json.createObject();
        Optional.ofNullable(this.name).ifPresent(value -> result.put("name", this.name));
        Optional.ofNullable(this.id).ifPresent(value -> result.put("id", this.id));
        Optional.ofNullable(this.avatar).ifPresent(value -> result.put("avatar", this.avatar));
        return result;
    }

    Sender(String name, String id, String avatar) {
        this.name = name;
        this.id = id;
        this.avatar = avatar;
    }

    public static SenderBuilder builder() {
        return new SenderBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public static class SenderBuilder {
        private String name;
        private String id;
        private String avatar;

        SenderBuilder() {
        }

        public SenderBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SenderBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SenderBuilder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Sender build() {
            return new Sender(this.name, this.id, this.avatar);
        }

        public String toString() {
            return "Sender.SenderBuilder(name=" + this.name + ", id=" + this.id + ", avatar=" + this.avatar + ")";
        }
    }
}

