/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import com.flowingcode.vaadin.addons.chatassistant.Sender;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.Optional;

public class Message {
    private String content;
    private boolean continued;
    private boolean right;
    private Integer delay;
    private boolean loading;
    private Sender sender;

    public JsonObject getJsonObject() {
        JsonObject result = Json.createObject();
        result.put("message", this.content);
        result.put("continued", this.continued);
        result.put("right", this.right);
        Optional.ofNullable(this.delay).ifPresent(value -> result.put("delay", (double)this.delay.intValue()));
        result.put("loading", this.loading);
        Optional.ofNullable(this.sender).ifPresent(value -> result.put("sender", this.sender.getJsonObject()));
        return result;
    }

    private static Integer $default$delay() {
        return 0;
    }

    Message(String content, boolean continued, boolean right, Integer delay, boolean loading, Sender sender) {
        this.content = content;
        this.continued = continued;
        this.right = right;
        this.delay = delay;
        this.loading = loading;
        this.sender = sender;
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public String getContent() {
        return this.content;
    }

    public boolean isContinued() {
        return this.continued;
    }

    public boolean isRight() {
        return this.right;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public Sender getSender() {
        return this.sender;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContinued(boolean continued) {
        this.continued = continued;
    }

    public void setRight(boolean right) {
        this.right = right;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public void setSender(Sender sender) {
        this.sender = sender;
    }

    public static class MessageBuilder {
        private String content;
        private boolean continued;
        private boolean right;
        private boolean delay$set;
        private Integer delay$value;
        private boolean loading;
        private Sender sender;

        MessageBuilder() {
        }

        public MessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public MessageBuilder continued(boolean continued) {
            this.continued = continued;
            return this;
        }

        public MessageBuilder right(boolean right) {
            this.right = right;
            return this;
        }

        public MessageBuilder delay(Integer delay) {
            this.delay$value = delay;
            this.delay$set = true;
            return this;
        }

        public MessageBuilder loading(boolean loading) {
            this.loading = loading;
            return this;
        }

        public MessageBuilder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        public Message build() {
            Integer delay$value = this.delay$value;
            if (!this.delay$set) {
                delay$value = Message.$default$delay();
            }
            return new Message(this.content, this.continued, this.right, delay$value, this.loading, this.sender);
        }

        public String toString() {
            return "Message.MessageBuilder(content=" + this.content + ", continued=" + this.continued + ", right=" + this.right + ", delay$value=" + this.delay$value + ", loading=" + this.loading + ", sender=" + this.sender + ")";
        }
    }
}

