/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chatassistant;

import com.flowingcode.vaadin.addons.chatassistant.Message;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@NpmPackage(value="wc-chatbot", version="0.1.1")
@JsModule(value="wc-chatbot/dist/wc-chatbot.js")
@CssImport(value="./styles/chat-assistant-styles.css")
@Tag(value="chat-bot")
public class ChatAssistant
extends Div {
    public void sendMessage(String message) {
        this.sendMessage(Message.builder().content(message).build());
    }

    public void toggle() {
        this.getElement().executeJs("setTimeout(() => {this.toggle();})", new Serializable[0]);
    }

    public void sendMessage(Message message) {
        this.getElement().executeJs("setTimeout(() => {this.sendMessage(null, JSON.parse($0));})", new Serializable[]{message.getJsonObject().toJson()});
    }

    public Registration addChatSentListener(ComponentEventListener<ChatSentEvent> listener) {
        return this.addListener(ChatSentEvent.class, listener);
    }

    @DomEvent(value="sent")
    public static class ChatSentEvent
    extends ComponentEvent<ChatAssistant> {
        private final String message;
        private boolean right;

        public ChatSentEvent(ChatAssistant source, boolean fromClient, @EventData(value="event.detail.message.message") String message, @EventData(value="event.detail.message.right") boolean right) {
            super((Component)source, fromClient);
            this.message = message.replaceAll("^<[^>]+>|<[^>]+>$", "");
            this.right = right;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isRight() {
            return this.right;
        }
    }
}

