/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.flowingcode.vaadin.jsonmigration.ElementalPendingJavaScriptResult;
import com.flowingcode.vaadin.jsonmigration.JsonMigrationHelper;
import com.flowingcode.vaadin.jsonmigration.LegacyJsonMigrationHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Version;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Method;
import lombok.Generated;

public final class JsonMigration {
    private static final JsonMigrationHelper helper = JsonMigration.initializeHelper();
    private static final Class<?> BASE_JSON_NODE = JsonMigration.lookup_BaseJsonNode();
    private static Method Element_setPropertyJson = JsonMigration.lookup_setPropertyJson();
    private static Method DomEvent_getEventData = JsonMigration.lookup_getEventData();
    private static Method Element_executeJs = JsonMigration.lookup_executeJs();

    private static JsonMigrationHelper initializeHelper() {
        if (Version.getMajorVersion() > 24) {
            Class<?> helperType = Class.forName(JsonMigration.class.getName() + "Helper25");
            return (JsonMigrationHelper)helperType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return new LegacyJsonMigrationHelper();
    }

    private static Class<?> lookup_BaseJsonNode() {
        try {
            return Class.forName("tools.jackson.databind.node.BaseJsonNode");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T extends JsonValue> T convertToClientCallableResult(T object) {
        return helper.convertToClientCallableResult(object);
    }

    public static JsonValue convertToJsonValue(Object object) {
        return helper.convertToJsonValue(object);
    }

    private static Object invoke(Method method, Object instance, Object ... args) {
        return helper.invoke(method, instance, args);
    }

    private static Method lookup_setPropertyJson() {
        if (Version.getMajorVersion() > 24) {
            return Element.class.getMethod("setPropertyJson", String.class, BASE_JSON_NODE);
        }
        return Element.class.getMethod("setPropertyJson", String.class, JsonValue.class);
    }

    private static Method lookup_getEventData() {
        return DomEvent.class.getMethod("getEventData", new Class[0]);
    }

    public static void setPropertyJson(Element element, String name, JsonValue json) {
        JsonMigration.invoke(Element_setPropertyJson, element, name, json);
    }

    private static Method lookup_executeJs() {
        if (Version.getMajorVersion() > 24) {
            return Element.class.getMethod("executeJs", String.class, Object[].class);
        }
        return Element.class.getMethod("executeJs", String.class, Serializable[].class);
    }

    public static ElementalPendingJavaScriptResult executeJs(Element element, String expression, Serializable ... parameters) {
        PendingJavaScriptResult result = (PendingJavaScriptResult)JsonMigration.invoke(Element_executeJs, element, expression, parameters);
        return helper.convertPendingJavaScriptResult(result);
    }

    public static JsonObject getEventData(DomEvent event) {
        return (JsonObject)JsonMigration.convertToJsonValue(JsonMigration.invoke(DomEvent_getEventData, event, new Object[0]));
    }

    public static <T extends Component> Class<? extends T> instrumentClass(Class<T> clazz) {
        return helper.instrumentClass(clazz);
    }

    @Generated
    private JsonMigration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

