/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.flowingcode.vaadin.jsonmigration.JsonMigrationHelper25;
import com.flowingcode.vaadin.jsonmigration.UnsupportedJsonValueImpl;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;

class ElementalObjectNode
extends ObjectNode
implements UnsupportedJsonValueImpl {
    public ElementalObjectNode(JsonObject o) {
        super(JsonNodeFactory.instance, ElementalObjectNode.children(o));
    }

    private static Map<String, JsonNode> children(JsonObject o) {
        String[] keys = o.keys();
        switch (keys.length) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(keys[0], JsonMigrationHelper25.convertToJsonNode(o.get(keys[0])));
            }
        }
        LinkedHashMap<String, JsonNode> children = new LinkedHashMap<String, JsonNode>(keys.length);
        for (String key : keys) {
            children.put(key, (JsonNode)JsonMigrationHelper25.convertToJsonNode(o.get(key)));
        }
        return children;
    }

    public JsonType getType() {
        return JsonType.OBJECT;
    }
}

