/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonNull;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class JsonSerializer {
    private JsonSerializer() {
    }

    public static JsonValue toJson(Object bean) {
        if (bean == null) {
            return Json.createNull();
        }
        if (bean instanceof Collection) {
            return JsonSerializer.toJson((Collection)bean);
        }
        if (bean.getClass().isArray()) {
            return JsonSerializer.toJsonArray(bean);
        }
        Optional<JsonValue> simpleType = JsonSerializer.tryToConvertToSimpleType(bean);
        if (simpleType.isPresent()) {
            return simpleType.get();
        }
        try {
            JsonObject json = Json.createObject();
            Class<?> type = bean.getClass();
            if (type.isRecord()) {
                for (RecordComponent rc : type.getRecordComponents()) {
                    json.put(rc.getName(), JsonSerializer.toJson(rc.getAccessor().invoke(bean, new Object[0])));
                }
            } else {
                BeanInfo info = Introspector.getBeanInfo(type);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Method reader;
                    if ("class".equals(pd.getName()) || (reader = pd.getReadMethod()) == null) continue;
                    json.put(pd.getName(), JsonSerializer.toJson(reader.invoke(bean, new Object[0])));
                }
            }
            return json;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize object of type " + bean.getClass() + " to JsonValue", e);
        }
    }

    public static JsonArray toJson(Collection<?> beans) {
        JsonArray array = Json.createArray();
        if (beans == null) {
            return array;
        }
        beans.stream().map(JsonSerializer::toJson).forEachOrdered(json -> array.set(array.length(), json));
        return array;
    }

    private static JsonArray toJsonArray(Object javaArray) {
        int length = Array.getLength(javaArray);
        JsonArray array = Json.createArray();
        for (int i = 0; i < length; ++i) {
            array.set(i, JsonSerializer.toJson(Array.get(javaArray, i)));
        }
        return array;
    }

    private static Optional<JsonValue> tryToConvertToSimpleType(Object bean) {
        if (bean instanceof String) {
            return Optional.of(Json.create((String)((String)bean)));
        }
        if (bean instanceof Number) {
            return Optional.of(Json.create((double)((Number)bean).doubleValue()));
        }
        if (bean instanceof Boolean) {
            return Optional.of(Json.create((boolean)((Boolean)bean)));
        }
        if (bean instanceof Character) {
            return Optional.of(Json.create((String)Character.toString(((Character)bean).charValue())));
        }
        if (bean instanceof Enum) {
            return Optional.of(Json.create((String)((Enum)bean).name()));
        }
        if (bean instanceof JsonValue) {
            return Optional.of((JsonValue)bean);
        }
        return Optional.empty();
    }

    public static <T> T toObject(Class<T> type, JsonValue json) {
        return JsonSerializer.toObject(type, null, json);
    }

    private static <T> T toObject(Class<T> type, Type genericType, JsonValue json) {
        T instance;
        if (json == null || json instanceof JsonNull) {
            return null;
        }
        Optional<?> simpleType = JsonSerializer.tryToConvertFromSimpleType(type, json);
        if (simpleType.isPresent()) {
            return (T)simpleType.get();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return JsonSerializer.toCollection(type, genericType, json);
        }
        if (type.isRecord()) {
            return JsonSerializer.toRecord(type, json);
        }
        try {
            instance = type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create an instance of type " + type + ". Make sure it contains a default public constructor and the class is accessible.", e);
        }
        try {
            JsonObject jsonObject = (JsonObject)json;
            String[] keys = jsonObject.keys();
            if (keys == null) {
                return instance;
            }
            BeanInfo info = Introspector.getBeanInfo(type);
            HashMap<String, Method> writers = new HashMap<String, Method>();
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Method writer = pd.getWriteMethod();
                if (writer == null) continue;
                writers.put(pd.getName(), writer);
            }
            for (String key : keys) {
                JsonValue jsonValue = jsonObject.get(key);
                Method method = (Method)writers.get(key);
                if (method == null) continue;
                Class<?> parameterType = method.getParameterTypes()[0];
                Type genericParameterType = method.getGenericParameterTypes()[0];
                Object value = JsonSerializer.toObject(parameterType, genericParameterType, jsonValue);
                method.invoke(instance, value);
            }
            return instance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not deserialize object of type " + type + " from JsonValue", e);
        }
    }

    private static <T> T toRecord(Class<T> type, JsonValue json) {
        try {
            RecordComponent[] components = type.getRecordComponents();
            Class[] componentTypes = new Class[components.length];
            Object[] values = new Object[components.length];
            for (int i = 0; i < components.length; ++i) {
                componentTypes[i] = components[i].getType();
                values[i] = JsonSerializer.toObject(componentTypes[i], ((JsonObject)json).get(components[i].getName()));
            }
            return type.getDeclaredConstructor(componentTypes).newInstance(values);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not deserialize record of type " + type + " from JsonValue", e);
        }
    }

    private static <T> T toCollection(Class<T> type, Type genericType, JsonValue json) {
        if (json.getType() != JsonType.ARRAY) {
            return null;
        }
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Could not infer the generic parameterized type of the collection of class: " + type.getName() + ". The type is no subclass of ParameterizedType: " + genericType);
        }
        JsonArray array = (JsonArray)json;
        Collection<?> collection = JsonSerializer.tryToCreateCollection(type, array.length());
        if (array.length() > 0) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Class parameterizedClass = (Class)parameterizedType.getActualTypeArguments()[0];
            collection.addAll(JsonSerializer.toObjects(parameterizedClass, (JsonArray)json));
        }
        return (T)collection;
    }

    public static <T> List<T> toObjects(Class<T> type, JsonArray json) {
        if (json == null) {
            return new ArrayList(0);
        }
        ArrayList<T> list = new ArrayList<T>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(JsonSerializer.toObject(type, json.get(i)));
        }
        return list;
    }

    private static Optional<?> tryToConvertFromSimpleType(Class<?> type, JsonValue json) {
        if (type.isAssignableFrom(String.class)) {
            return Optional.of(json.asString());
        }
        if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
            return Optional.of((int)json.asNumber());
        }
        if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
            return Optional.of(json.asNumber());
        }
        if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
            return Optional.of((long)json.asNumber());
        }
        if (type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Short.class)) {
            return Optional.of((short)json.asNumber());
        }
        if (type.isAssignableFrom(Byte.TYPE) || type.isAssignableFrom(Byte.class)) {
            return Optional.of((byte)json.asNumber());
        }
        if (type.isAssignableFrom(Character.TYPE) || type.isAssignableFrom(Character.class)) {
            return Optional.of(Character.valueOf(json.asString().charAt(0)));
        }
        if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            return Optional.of(json.asBoolean());
        }
        if (type.isEnum()) {
            return Optional.of(Enum.valueOf(type, json.asString()));
        }
        if (JsonValue.class.isAssignableFrom(type)) {
            return Optional.of(json);
        }
        return Optional.empty();
    }

    private static Collection<?> tryToCreateCollection(Class<?> collectionType, int initialCapacity) {
        if (collectionType.isInterface()) {
            if (List.class.isAssignableFrom(collectionType)) {
                return new ArrayList(initialCapacity);
            }
            if (Set.class.isAssignableFrom(collectionType)) {
                return new LinkedHashSet(initialCapacity);
            }
            throw new IllegalArgumentException("Collection type not supported: '" + collectionType.getName() + "'. Use Lists, Sets or concrete classes that implement java.util.Collection.");
        }
        try {
            return (Collection)collectionType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create an instance of the collection of type " + collectionType + ". Make sure it contains a default public constructor and the class is accessible.", e);
        }
    }
}

