/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.flowingcode.vaadin.jsonmigration.ClassInstrumentationUtil;
import com.flowingcode.vaadin.jsonmigration.ElementalArrayNode;
import com.flowingcode.vaadin.jsonmigration.ElementalBooleanNode;
import com.flowingcode.vaadin.jsonmigration.ElementalNullNode;
import com.flowingcode.vaadin.jsonmigration.ElementalNumberNode;
import com.flowingcode.vaadin.jsonmigration.ElementalObjectNode;
import com.flowingcode.vaadin.jsonmigration.ElementalPendingJavaScriptResult;
import com.flowingcode.vaadin.jsonmigration.ElementalStringNode;
import com.flowingcode.vaadin.jsonmigration.JsonCodec;
import com.flowingcode.vaadin.jsonmigration.JsonMigrationHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;

class JsonMigrationHelper25
implements JsonMigrationHelper {
    private static final ClassInstrumentationUtil instrumentation = new ClassInstrumentationUtil(25);
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

    @Override
    public <T extends Component> Class<? extends T> instrumentClass(Class<T> clazz) {
        return instrumentation.instrumentClass(clazz);
    }

    @Override
    public JsonValue convertToJsonValue(Object object) {
        if (object instanceof JsonValue) {
            return (JsonValue)object;
        }
        if (object instanceof JsonNode) {
            return JsonMigrationHelper25.convertToJsonValue((JsonNode)object);
        }
        if (object == null) {
            return null;
        }
        throw new ClassCastException(object.getClass().getName() + " cannot be converted to elemental.json.JsonObject");
    }

    public JsonValue convertToClientCallableResult(JsonValue object) {
        if (object == null) {
            return null;
        }
        switch (object.getType()) {
            case OBJECT: {
                return new ElementalObjectNode((JsonObject)object);
            }
            case ARRAY: {
                return new ElementalArrayNode((JsonArray)object);
            }
            case BOOLEAN: {
                return new ElementalBooleanNode(object.asBoolean());
            }
            case NULL: {
                return new ElementalNullNode();
            }
            case NUMBER: {
                return new ElementalNumberNode(object.asNumber());
            }
            case STRING: {
                return new ElementalStringNode(object.asString());
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object invoke(Method method, Object instance, Object ... args) {
        Object[] convertedArgs = null;
        int j = args.length - 1;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (args.length == parameterTypes.length) {
            ?[] convertedArray;
            if (method.isVarArgs() && args[j] instanceof Object[] && (convertedArray = JsonMigrationHelper25.convertArray((Object[])args[j], parameterTypes[j].getComponentType())) != null) {
                convertedArgs = Arrays.copyOf(args, args.length);
                convertedArgs[j] = convertedArray;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (!(args[i] instanceof JsonValue) || parameterTypes[i] != BaseJsonNode.class) continue;
                if (convertedArgs == null) {
                    convertedArgs = Arrays.copyOf(args, args.length);
                }
                convertedArgs[i] = JsonMigrationHelper25.convertToJsonNode((JsonValue)args[i]);
            }
        }
        if (convertedArgs == null) {
            convertedArgs = args;
        }
        return method.invoke(instance, convertedArgs);
    }

    private static <T> T[] convertArray(Object[] array, Class<? extends T> newType) {
        Object[] convertedArray = null;
        if (newType.isAssignableFrom(BaseJsonNode.class)) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] instanceof JsonValue) {
                    BaseJsonNode t;
                    if (convertedArray == null) {
                        Object[] copy;
                        Object[] objectArray = copy = newType == Object.class ? new Object[array.length] : (Object[])Array.newInstance(newType, array.length);
                        if (i > 0) {
                            System.arraycopy(array, 0, copy, 0, i);
                        }
                        convertedArray = copy;
                    }
                    convertedArray[i] = t = JsonMigrationHelper25.convertToJsonNode((JsonValue)array[i]);
                    continue;
                }
                if (convertedArray == null) continue;
                convertedArray[i] = newType.cast(array[i]);
            }
        }
        return convertedArray;
    }

    private static JsonValue convertToJsonValue(JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case OBJECT: {
                JsonObject jsonObject = Json.createObject();
                ObjectNode source = (ObjectNode)jsonNode;
                for (String key : source.propertyNames()) {
                    jsonObject.put(key, JsonMigrationHelper25.convertToJsonValue(source.get(key)));
                }
                return jsonObject;
            }
            case ARRAY: {
                JsonArray jsonArray = Json.createArray();
                for (int i = 0; i < jsonNode.size(); ++i) {
                    jsonArray.set(i, JsonMigrationHelper25.convertToJsonValue(jsonNode.get(i)));
                }
                return jsonArray;
            }
            case STRING: {
                return Json.create((String)jsonNode.asText());
            }
            case NUMBER: {
                return Json.create((double)jsonNode.asDouble());
            }
            case BOOLEAN: {
                return Json.create((boolean)jsonNode.asBoolean());
            }
            case NULL: {
                return Json.createNull();
            }
        }
        throw new IllegalArgumentException("Unsupported JsonNode type: " + jsonNode.getNodeType());
    }

    static BaseJsonNode convertToJsonNode(JsonValue jsonValue) {
        switch (jsonValue.getType()) {
            case OBJECT: {
                JsonObject jsonObject = (JsonObject)jsonValue;
                ObjectNode objectNode = nodeFactory.objectNode();
                for (String key : jsonObject.keys()) {
                    objectNode.set(key, (JsonNode)JsonMigrationHelper25.convertToJsonNode(jsonObject.get(key)));
                }
                return objectNode;
            }
            case ARRAY: {
                JsonArray jsonArray = (JsonArray)jsonValue;
                ArrayNode arrayNode = nodeFactory.arrayNode(jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    arrayNode.add((JsonNode)JsonMigrationHelper25.convertToJsonNode(jsonArray.get(i)));
                }
                return arrayNode;
            }
            case STRING: {
                return nodeFactory.textNode(jsonValue.asString());
            }
            case NUMBER: {
                return nodeFactory.numberNode(jsonValue.asNumber());
            }
            case BOOLEAN: {
                return nodeFactory.booleanNode(jsonValue.asBoolean());
            }
            case NULL: {
                return nodeFactory.nullNode();
            }
        }
        throw new IllegalArgumentException("Unsupported JsonValue type: " + jsonValue.getType());
    }

    @Override
    public ElementalPendingJavaScriptResult convertPendingJavaScriptResult(PendingJavaScriptResult result) {
        return new PendingJavaScriptResultImpl(result);
    }

    @Generated
    public JsonMigrationHelper25() {
    }

    private static final class PendingJavaScriptResultImpl
    implements ElementalPendingJavaScriptResult {
        private final PendingJavaScriptResult delegate;

        private static SerializableConsumer wrap(SerializableConsumer<JsonValue> resultHandler) {
            return (SerializableConsumer & Serializable)node -> resultHandler.accept((Object)JsonMigrationHelper25.convertToJsonValue(node));
        }

        private static <T> T decodeAs(JsonNode node, Class<T> type) {
            return JsonCodec.decodeAs(JsonMigrationHelper25.convertToJsonValue(node), type);
        }

        @Override
        public void then(SerializableConsumer<JsonValue> resultHandler, SerializableConsumer<String> errorHandler) {
            this.delegate.then(PendingJavaScriptResultImpl.wrap(resultHandler), errorHandler);
        }

        @Override
        public <T> void then(Class<T> targetType, SerializableConsumer<T> resultHandler, SerializableConsumer<String> errorHandler) {
            if (targetType != null && JsonValue.class.isAssignableFrom(targetType)) {
                this.delegate.then(JsonNode.class, PendingJavaScriptResultImpl.wrap((SerializableConsumer<JsonValue>)(SerializableConsumer & Serializable)value -> resultHandler.accept(JsonCodec.decodeAs(value, targetType))), errorHandler);
            } else {
                this.delegate.then(targetType, resultHandler, errorHandler);
            }
        }

        @Override
        public <T> CompletableFuture<T> toCompletableFuture(Class<T> targetType) {
            if (JsonValue.class.isAssignableFrom(targetType)) {
                return this.delegate.toCompletableFuture(JsonNode.class).thenApply(node -> PendingJavaScriptResultImpl.decodeAs(node, targetType));
            }
            return this.delegate.toCompletableFuture(targetType);
        }

        @Generated
        public PendingJavaScriptResultImpl(PendingJavaScriptResult delegate) {
            this.delegate = delegate;
        }
    }
}

