/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.vaadin.flow.internal.ReflectTools;
import elemental.json.Json;
import elemental.json.JsonType;
import elemental.json.JsonValue;

public class JsonCodec {
    public static <T> T decodeAs(JsonValue json, Class<T> type) {
        assert (json != null);
        if (json.getType() == JsonType.NULL && !type.isPrimitive()) {
            return null;
        }
        Class convertedType = ReflectTools.convertPrimitiveType(type);
        if (type == String.class) {
            return type.cast(json.asString());
        }
        if (convertedType == Boolean.class) {
            return convertedType.cast(json.asBoolean());
        }
        if (convertedType == Double.class) {
            return convertedType.cast(json.asNumber());
        }
        if (convertedType == Integer.class) {
            return convertedType.cast((int)json.asNumber());
        }
        if (JsonValue.class.isAssignableFrom(type)) {
            return type.cast(json);
        }
        throw new IllegalArgumentException("Unknown type " + type.getName());
    }

    public static boolean canEncodeWithoutTypeInfo(Class<?> type) {
        assert (type != null);
        return String.class.equals(type) || Integer.class.equals(type) || Double.class.equals(type) || Boolean.class.equals(type) || JsonValue.class.isAssignableFrom(type);
    }

    public static JsonValue encodeWithoutTypeInfo(Object value) {
        if (value == null) {
            return Json.createNull();
        }
        assert (JsonCodec.canEncodeWithoutTypeInfo(value.getClass()));
        Class<?> type = value.getClass();
        if (String.class.equals(value.getClass())) {
            return Json.create((String)((String)value));
        }
        if (Integer.class.equals(type) || Double.class.equals(type)) {
            return Json.create((double)((Number)value).doubleValue());
        }
        if (Boolean.class.equals(type)) {
            return Json.create((boolean)((Boolean)value));
        }
        if (JsonValue.class.isAssignableFrom(type)) {
            return (JsonValue)value;
        }
        assert (!JsonCodec.canEncodeWithoutTypeInfo(type));
        throw new IllegalArgumentException("Can't encode " + value.getClass() + " to json");
    }
}

