/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.flowingcode.vaadin.jsonmigration.JsonMigrationHelper25;
import com.flowingcode.vaadin.jsonmigration.UnsupportedJsonValueImpl;
import elemental.json.JsonArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeFactory;

class ElementalArrayNode
extends ArrayNode
implements UnsupportedJsonValueImpl {
    public ElementalArrayNode(JsonArray a) {
        super(JsonNodeFactory.instance, ElementalArrayNode.children(a));
    }

    private static List<JsonNode> children(JsonArray a) {
        switch (a.length()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(JsonMigrationHelper25.convertToJsonNode(a.get(0)));
            }
        }
        ArrayList<JsonNode> children = new ArrayList<JsonNode>(a.length());
        int n = a.length();
        for (int i = 0; i < n; ++i) {
            children.add((JsonNode)JsonMigrationHelper25.convertToJsonNode(a.get(i)));
        }
        return children;
    }
}

