/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.flowingcode.vaadin.jsonmigration.LegacyClientCallable;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import elemental.json.JsonArray;
import elemental.json.JsonBoolean;
import elemental.json.JsonNumber;
import elemental.json.JsonObject;
import elemental.json.JsonString;
import elemental.json.JsonValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.DoubleNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.StringNode;

final class ClassInstrumentationUtil {
    private static final Map<ClassLoader, InstrumentedClassLoader> classLoaderCache = new WeakHashMap<ClassLoader, InstrumentedClassLoader>();

    public static <T extends Component> Class<? extends T> instrumentClass(Class<T> parent) {
        block12: {
            if (parent == null) {
                throw new IllegalArgumentException("Parent class cannot be null");
            }
            if (parent.isInterface()) {
                throw new IllegalArgumentException("Cannot instrument an interface: " + parent.getName());
            }
            if (parent.isPrimitive()) {
                throw new IllegalArgumentException("Cannot instrument a primitive type: " + parent.getName());
            }
            if (parent.isArray()) {
                throw new IllegalArgumentException("Cannot instrument an array type: " + parent.getName());
            }
            if (Modifier.isFinal(parent.getModifiers())) {
                throw new IllegalArgumentException("Cannot instrument a final class: " + parent.getName());
            }
            if (!ClassInstrumentationUtil.needsInstrumentation(parent)) {
                return parent;
            }
            try {
                Constructor<T> defaultConstructor = parent.getDeclaredConstructor(new Class[0]);
                if (Modifier.isPublic(defaultConstructor.getModifiers()) || Modifier.isProtected(defaultConstructor.getModifiers())) break block12;
                try {
                    defaultConstructor.setAccessible(true);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Parent class must have an accessible no-argument constructor: " + parent.getName(), e);
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Parent class must have a no-argument constructor: " + parent.getName(), e);
            }
        }
        try {
            String instrumentedClassName = parent.getName() + "$Instrumented";
            return ClassInstrumentationUtil.createInstrumentedClass(parent, instrumentedClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instrument " + parent.getName(), e);
        }
    }

    private static boolean needsInstrumentation(Class<?> parent) {
        return !ClassInstrumentationUtil.getInstrumentableMethods(parent).isEmpty();
    }

    private static List<Method> getInstrumentableMethods(Class<?> parent) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : parent.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || Modifier.isPrivate(method.getModifiers())) continue;
            boolean isCallable = method.isAnnotationPresent(ClientCallable.class);
            boolean isLegacyCallable = method.isAnnotationPresent(LegacyClientCallable.class);
            if (!isCallable && !isLegacyCallable) continue;
            boolean hasJsonValueReturn = JsonValue.class.isAssignableFrom(method.getReturnType());
            boolean hasJsonValueParams = ClassInstrumentationUtil.hasJsonValueParameters(method);
            if (isCallable && hasJsonValueParams) {
                throw new IllegalArgumentException(String.format("Instrumented method '%s' in class '%s' has JsonValue arguments and must be annotated with @%s instead of @ClientCallable", method.getName(), method.getDeclaringClass().getName(), LegacyClientCallable.class.getName()));
            }
            if (isCallable && hasJsonValueReturn) {
                methods.add(method);
                continue;
            }
            if (!isLegacyCallable) continue;
            methods.add(method);
        }
        return methods;
    }

    private static boolean hasJsonValueParameters(Method method) {
        for (Class<?> paramType : method.getParameterTypes()) {
            if (!JsonValue.class.isAssignableFrom(paramType)) continue;
            return true;
        }
        return false;
    }

    private static <T extends Component> Class<? extends T> createInstrumentedClass(Class<T> parent, String className) throws Exception {
        InstrumentedClassLoader classLoader = ClassInstrumentationUtil.getOrCreateInstrumentedClassLoader(parent.getClassLoader());
        return classLoader.defineInstrumentedClass(className, parent).asSubclass(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstrumentedClassLoader getOrCreateInstrumentedClassLoader(ClassLoader parent) {
        Map<ClassLoader, InstrumentedClassLoader> map = classLoaderCache;
        synchronized (map) {
            return classLoaderCache.computeIfAbsent(parent, InstrumentedClassLoader::new);
        }
    }

    @Generated
    private ClassInstrumentationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class InstrumentedClassLoader
    extends ClassLoader {
        private final Map<Class<?>, Class<?>> instrumentedClassCache = new ConcurrentHashMap();

        public InstrumentedClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineInstrumentedClass(String className, Class<?> parent) {
            return this.instrumentedClassCache.computeIfAbsent(parent, p -> {
                byte[] bytecode = this.generateBytecode(className, (Class<?>)p);
                return this.defineClass(className, bytecode, 0, bytecode.length);
            });
        }

        private byte[] generateBytecode(String className, Class<?> parent) {
            String internalClassName = className.replace('.', '/');
            String internalParentName = parent.getName().replace('.', '/');
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 1, internalClassName, null, internalParentName, null);
            this.generateConstructor(cw, internalParentName);
            this.generateClientCallableOverrides(cw, parent, internalParentName);
            cw.visitEnd();
            return cw.toByteArray();
        }

        private void generateConstructor(ClassWriter cw, String internalParentName) {
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, internalParentName, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateClientCallableOverrides(ClassWriter cw, Class<?> parent, String internalParentName) {
            for (Method method : ClassInstrumentationUtil.getInstrumentableMethods(parent)) {
                this.generateMethodOverride(cw, method, internalParentName);
            }
        }

        private void generateMethodOverride(ClassWriter cw, Method method, String internalParentName) {
            boolean hasJsonValueReturn = JsonValue.class.isAssignableFrom(method.getReturnType());
            boolean hasJsonValueParams = ClassInstrumentationUtil.hasJsonValueParameters(method);
            String overrideDescriptor = this.getMethodDescriptor(method, hasJsonValueParams);
            String superDescriptor = this.getMethodDescriptor(method, false);
            int access = method.getModifiers() & 5;
            MethodVisitor mv = cw.visitMethod(access, method.getName(), overrideDescriptor, null, this.getExceptionInternalNames(method.getExceptionTypes()));
            mv.visitAnnotation(Type.getDescriptor(ClientCallable.class), true);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            Class<?>[] paramTypes = method.getParameterTypes();
            int localVarIndex = 1;
            for (Class<?> paramType : paramTypes) {
                if (hasJsonValueParams && JsonValue.class.isAssignableFrom(paramType)) {
                    mv.visitVarInsn(25, localVarIndex);
                    mv.visitMethodInsn(184, "com/flowingcode/vaadin/jsonmigration/JsonMigration", "convertToJsonValue", "(Ljava/lang/Object;)Lelemental/json/JsonValue;", false);
                    if (paramType != JsonValue.class) {
                        mv.visitTypeInsn(192, Type.getInternalName(paramType));
                    }
                    ++localVarIndex;
                    continue;
                }
                localVarIndex += this.loadParameter(mv, paramType, localVarIndex);
            }
            mv.visitMethodInsn(183, internalParentName, method.getName(), superDescriptor, false);
            if (hasJsonValueReturn) {
                mv.visitVarInsn(58, localVarIndex);
                mv.visitVarInsn(25, localVarIndex);
                mv.visitMethodInsn(184, "com/flowingcode/vaadin/jsonmigration/JsonMigration", "convertToClientCallableResult", "(Lelemental/json/JsonValue;)Lelemental/json/JsonValue;", false);
            }
            if (method.getReturnType() == Void.TYPE) {
                mv.visitInsn(177);
            } else {
                mv.visitInsn(176);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private int loadParameter(MethodVisitor mv, Class<?> paramType, int localVarIndex) {
            if (!paramType.isPrimitive()) {
                mv.visitVarInsn(25, localVarIndex);
                return 1;
            }
            if (paramType == Long.TYPE) {
                mv.visitVarInsn(22, localVarIndex);
                return 2;
            }
            if (paramType == Float.TYPE) {
                mv.visitVarInsn(23, localVarIndex);
                return 1;
            }
            if (paramType == Double.TYPE) {
                mv.visitVarInsn(24, localVarIndex);
                return 2;
            }
            mv.visitVarInsn(21, localVarIndex);
            return 1;
        }

        private String getMethodDescriptor(Method method, boolean convertJsonValueParams) {
            StringBuilder sb = new StringBuilder("(");
            for (Class<?> paramType : method.getParameterTypes()) {
                if (convertJsonValueParams && JsonValue.class.isAssignableFrom(paramType)) {
                    sb.append(this.getConvertedTypeDescriptor(paramType));
                    continue;
                }
                sb.append(Type.getDescriptor(paramType));
            }
            sb.append(")");
            sb.append(Type.getDescriptor(method.getReturnType()));
            return sb.toString();
        }

        private String getConvertedTypeDescriptor(Class<?> type) {
            if (type == JsonObject.class) {
                return Type.getDescriptor(ObjectNode.class);
            }
            if (type == JsonArray.class) {
                return Type.getDescriptor(ArrayNode.class);
            }
            if (type == JsonBoolean.class) {
                return Type.getDescriptor(BooleanNode.class);
            }
            if (type == JsonNumber.class) {
                return Type.getDescriptor(DoubleNode.class);
            }
            if (type == JsonString.class) {
                return Type.getDescriptor(StringNode.class);
            }
            if (JsonValue.class.isAssignableFrom(type)) {
                return Type.getDescriptor(JsonNode.class);
            }
            return Type.getDescriptor(type);
        }

        private String[] getExceptionInternalNames(Class<?>[] exceptionTypes) {
            if (exceptionTypes == null || exceptionTypes.length == 0) {
                return null;
            }
            String[] names = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                names[i] = exceptionTypes[i].getName().replace('.', '/');
            }
            return names;
        }
    }
}

