/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.vaadin.flow.internal.ReflectTools;
import elemental.json.JsonType;
import elemental.json.JsonValue;

class JsonCodec {
    JsonCodec() {
    }

    public static <T> T decodeAs(JsonValue json, Class<T> type) {
        assert (json != null);
        if (json.getType() == JsonType.NULL && !type.isPrimitive()) {
            return null;
        }
        Class convertedType = ReflectTools.convertPrimitiveType(type);
        if (type == String.class) {
            return type.cast(json.asString());
        }
        if (convertedType == Boolean.class) {
            return convertedType.cast(json.asBoolean());
        }
        if (convertedType == Double.class) {
            return convertedType.cast(json.asNumber());
        }
        if (convertedType == Integer.class) {
            return convertedType.cast((int)json.asNumber());
        }
        if (JsonValue.class.isAssignableFrom(type)) {
            return type.cast(json);
        }
        throw new IllegalArgumentException("Unknown type " + type.getName());
    }
}

