/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.flowingcode.vaadin.jsonmigration.JsonMigrationHelper;
import com.flowingcode.vaadin.jsonmigration.LegacyJsonMigrationHelper;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Version;
import elemental.json.JsonValue;
import java.lang.reflect.Method;

public class JsonMigration {
    private static final JsonMigrationHelper helper = JsonMigration.initializeHelper();
    private static final Class<?> BASE_JSON_NODE = JsonMigration.lookup_BaseJsonNode();
    private static Method Element_setPropertyJson = JsonMigration.lookup_setPropertyJson();

    private static JsonMigrationHelper initializeHelper() {
        if (Version.getMajorVersion() > 24) {
            Class<?> helperType = Class.forName(JsonMigration.class.getName() + "Helper25");
            return (JsonMigrationHelper)helperType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return new LegacyJsonMigrationHelper();
    }

    private static Class<?> lookup_BaseJsonNode() {
        try {
            return Class.forName("tools.jackson.databind.node.BaseJsonNode");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static JsonValue convertToJsonValue(Object object) {
        return helper.convertToJsonValue(object);
    }

    private static Object invoke(Method method, Object instance, Object ... args) {
        return helper.invoke(method, instance, args);
    }

    private static Method lookup_setPropertyJson() {
        if (Version.getMajorVersion() > 24) {
            return Element.class.getMethod("setPropertyJson", String.class, BASE_JSON_NODE);
        }
        return Element.class.getMethod("setPropertyJson", String.class, JsonValue.class);
    }

    public static void setPropertyJson(Element element, String name, JsonValue json) {
        JsonMigration.invoke(Element_setPropertyJson, element, name, json);
    }
}

