/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.jsonmigration;

import com.flowingcode.vaadin.jsonmigration.JsonMigrationHelper;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.lang.reflect.Method;
import java.util.Arrays;
import lombok.Generated;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;

class JsonMigrationHelper25
implements JsonMigrationHelper {
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

    @Override
    public JsonValue convertToJsonValue(Object object) {
        if (object instanceof JsonValue) {
            return (JsonValue)object;
        }
        if (object instanceof JsonNode) {
            return JsonMigrationHelper25.convertToJsonValue((JsonNode)object);
        }
        if (object == null) {
            return null;
        }
        throw new ClassCastException(object.getClass().getName() + " cannot be converted to elemental.json.JsonObject");
    }

    @Override
    public Object invoke(Method method, Object instance, Object ... args) {
        Object[] convertedArgs = null;
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!(args[i] instanceof JsonValue) || parameterTypes[i] != BaseJsonNode.class) continue;
            if (convertedArgs == null) {
                convertedArgs = Arrays.copyOf(args, args.length);
            }
            convertedArgs[i] = JsonMigrationHelper25.convertToJsonNode((JsonValue)args[i]);
        }
        if (convertedArgs == null) {
            convertedArgs = args;
        }
        return method.invoke(instance, convertedArgs);
    }

    private static JsonValue convertToJsonValue(JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case OBJECT: {
                JsonObject jsonObject = Json.createObject();
                JsonObject source = (JsonObject)jsonNode;
                for (String key : source.keys()) {
                    jsonObject.put(key, JsonMigrationHelper25.convertToJsonValue((JsonNode)source.get(key)));
                }
                return jsonObject;
            }
            case ARRAY: {
                JsonArray jsonArray = Json.createArray();
                for (int i = 0; i < jsonNode.size(); ++i) {
                    jsonArray.set(i, JsonMigrationHelper25.convertToJsonValue(jsonNode.get(i)));
                }
                return jsonArray;
            }
            case STRING: {
                return Json.create((String)jsonNode.asText());
            }
            case NUMBER: {
                return Json.create((double)jsonNode.asDouble());
            }
            case BOOLEAN: {
                return Json.create((boolean)jsonNode.asBoolean());
            }
            case NULL: {
                return Json.createNull();
            }
        }
        throw new IllegalArgumentException("Unsupported JsonNode type: " + jsonNode.getNodeType());
    }

    private static BaseJsonNode convertToJsonNode(JsonValue jsonValue) {
        switch (jsonValue.getType()) {
            case OBJECT: {
                JsonObject jsonObject = (JsonObject)jsonValue;
                ObjectNode objectNode = nodeFactory.objectNode();
                for (String key : jsonObject.keys()) {
                    objectNode.set(key, (JsonNode)JsonMigrationHelper25.convertToJsonNode(jsonObject.get(key)));
                }
                return objectNode;
            }
            case ARRAY: {
                JsonArray jsonArray = (JsonArray)jsonValue;
                ArrayNode arrayNode = nodeFactory.arrayNode(jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    arrayNode.set(i, (JsonNode)JsonMigrationHelper25.convertToJsonNode(jsonArray.get(i)));
                }
                return arrayNode;
            }
            case STRING: {
                return nodeFactory.textNode(jsonValue.asString());
            }
            case NUMBER: {
                return nodeFactory.numberNode(jsonValue.asNumber());
            }
            case BOOLEAN: {
                return nodeFactory.booleanNode(jsonValue.asBoolean());
            }
            case NULL: {
                return nodeFactory.nullNode();
            }
        }
        throw new IllegalArgumentException("Unsupported JsonValue type: " + jsonValue.getType());
    }

    @Generated
    public JsonMigrationHelper25() {
    }
}

