/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.zoomist;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.zoomist.Zoomist;
import com.flowingcode.vaadin.addons.zoomist.ZoomistDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@DemoSource
@PageTitle(value="Zoomist Demo")
@Route(value="zoomist/demo", layout=ZoomistDemoView.class)
public class ZoomistDemo
extends Div {
    public ZoomistDemo() {
        Zoomist zoomist = new Zoomist("images/helsinki.jpg");
        zoomist.setSlider(null, Zoomist.Direction.VERTICAL, Double.valueOf(10.0));
        zoomist.setZoomer(true);
        zoomist.setDraggable(false);
        zoomist.setFill(Zoomist.Fill.COVER);
        zoomist.addDragStartListener((ComponentEventListener & Serializable)e -> Notification.show((String)("Drag started at (" + e.getOffsetX() + ", " + e.getOffsetY() + ")")));
        zoomist.addDragEndListener((ComponentEventListener & Serializable)e -> Notification.show((String)("Drag ended at (" + e.getOffsetX() + ", " + e.getOffsetY() + ")")));
        ComboBox sliderDirection = new ComboBox("Slider Direction", (Object[])Zoomist.Direction.values());
        sliderDirection.setValue((Object)Zoomist.Direction.VERTICAL);
        sliderDirection.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> zoomist.setSlider(null, (Zoomist.Direction)e.getValue(), null));
        Checkbox slider = new Checkbox("Show slider", zoomist.isSlider());
        slider.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((Boolean)e.getValue()).booleanValue()) {
                zoomist.setSlider(null, (Zoomist.Direction)sliderDirection.getValue(), null);
            } else {
                zoomist.setSlider(false);
            }
        });
        Checkbox zoomer = new Checkbox("Show zoomer", zoomist.isZoomer());
        zoomer.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> zoomist.setZoomer(((Boolean)e.getValue()).booleanValue()));
        Checkbox draggable = new Checkbox("Draggable", false);
        draggable.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> zoomist.setDraggable(((Boolean)e.getValue()).booleanValue()));
        Checkbox pinchable = new Checkbox("Pinchable", true);
        pinchable.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> zoomist.setPinchable(((Boolean)e.getValue()).booleanValue()));
        Checkbox wheelable = new Checkbox("Wheelable", true);
        wheelable.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> zoomist.setWheelable(((Boolean)e.getValue()).booleanValue()));
        TextField zoom = new TextField("Zoom");
        zoom.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> zoomist.zoom(Double.valueOf((String)e.getValue()).doubleValue()));
        TextField zoomRatio = new TextField("Zoom Ratio");
        zoomRatio.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> zoomist.setZoomRatio(Double.valueOf((String)e.getValue()).doubleValue()));
        zoomist.addZoomListener((ComponentEventListener & Serializable)e -> zoomRatio.setValue(String.valueOf(e.getRatio())));
        Button reset = new Button("Reset");
        reset.addClickListener((ComponentEventListener & Serializable)e -> zoomist.reset());
        Button displayZoomRatio = new Button("Display zoom ratio");
        displayZoomRatio.addClickListener((ComponentEventListener & Serializable)e -> Notification.show((String)String.valueOf(zoomist.getZoomRatio())));
        Span displayContainerData = new Span();
        Button getContainerData = new Button("Container Data");
        getContainerData.addClickListener((ComponentEventListener & Serializable)e -> zoomist.getContainerData((SerializableConsumer & Serializable)containerData -> {
            displayContainerData.removeAll();
            displayContainerData.add("Height " + containerData.getHeight());
            displayContainerData.add(" - Width " + containerData.getWidth());
            displayContainerData.add(" - Aspect Ratio " + containerData.getAspectRatio());
        }));
        this.add(new Component[]{zoomist, new HorizontalLayout(new Component[]{slider, zoomer, draggable, pinchable, wheelable}), new HorizontalLayout(new Component[]{sliderDirection, zoom, zoomRatio}), new HorizontalLayout(new Component[]{reset, getContainerData, displayZoomRatio}), displayContainerData});
    }
}

