/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.zoomist;

import com.flowingcode.vaadin.addons.zoomist.ContainerData;
import com.flowingcode.vaadin.addons.zoomist.DragEndEvent;
import com.flowingcode.vaadin.addons.zoomist.DragEvent;
import com.flowingcode.vaadin.addons.zoomist.DragStartEvent;
import com.flowingcode.vaadin.addons.zoomist.PinchEndEvent;
import com.flowingcode.vaadin.addons.zoomist.PinchEvent;
import com.flowingcode.vaadin.addons.zoomist.PinchStartEvent;
import com.flowingcode.vaadin.addons.zoomist.ReadyEvent;
import com.flowingcode.vaadin.addons.zoomist.ResizeEvent;
import com.flowingcode.vaadin.addons.zoomist.SlideEndEvent;
import com.flowingcode.vaadin.addons.zoomist.SlideEvent;
import com.flowingcode.vaadin.addons.zoomist.SlideStartEvent;
import com.flowingcode.vaadin.addons.zoomist.WheelEvent;
import com.flowingcode.vaadin.addons.zoomist.ZoomEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

@NpmPackage.Container(value={@NpmPackage(value="zoomist", version="1.1.1"), @NpmPackage(value="sass", version="1.66.1")})
@JsModule(value="./zoomist/fc-zoomist.ts")
@Tag(value="fc-zoomist")
public class Zoomist
extends Component {
    public Zoomist(String src) {
        this.setSrc(src);
    }

    public void setSrc(String src) {
        this.getElement().setProperty("src", src);
    }

    public void setSlider(boolean visible) {
        this.getElement().setProperty("slider", visible);
    }

    public void setSlider(String el, Direction direction, Double maxRatio) {
        JsonObject options = Json.createObject();
        if (el != null) {
            options.put("el", el);
        }
        if (direction != null) {
            options.put("direction", direction.value);
        }
        if (maxRatio != null) {
            options.put("maxRatio", maxRatio.doubleValue());
        }
        this.getElement().setPropertyJson("slider", (JsonValue)options);
    }

    public boolean isSlider() {
        return this.getElement().getProperty("slider", false);
    }

    public void setZoomer(boolean visible) {
        this.getElement().setProperty("zoomer", visible);
    }

    public void setZoomer(String inEl, String outEl, boolean disableOnBounds) {
        JsonObject options = Json.createObject();
        if (inEl != null) {
            options.put("inEl", inEl);
        }
        if (outEl != null) {
            options.put("outEl", outEl);
        }
        options.put("disableOnBounds", disableOnBounds);
        this.getElement().setPropertyJson("zoomer", (JsonValue)options);
    }

    public boolean isZoomer() {
        return this.getElement().getProperty("zoomer", false);
    }

    public Fill getFill() {
        return Fill.valueOf(this.getElement().getProperty("fill", Fill.NONE.value));
    }

    public void setFill(Fill fill) {
        Objects.requireNonNull(fill);
        this.getElement().setProperty("fill", fill.value);
    }

    public void setDraggable(boolean draggable) {
        this.getElement().setProperty("draggable", draggable);
    }

    public boolean isDraggable() {
        return this.getElement().getProperty("draggable", false);
    }

    public void setWheelable(boolean wheelable) {
        this.getElement().setProperty("wheelable", wheelable);
    }

    public boolean isWheelable() {
        return this.getElement().getProperty("wheelable", false);
    }

    public void setPinchable(boolean pinchable) {
        this.getElement().setProperty("pinchable", pinchable);
    }

    public boolean isPinchable() {
        return this.getElement().getProperty("pinchable", false);
    }

    public void setBounds(boolean bounds) {
        this.getElement().setProperty("bounds", bounds);
    }

    public boolean isBounds() {
        return this.getElement().getProperty("bounds", false);
    }

    public void setZoomRatio(double value) {
        this.getElement().setProperty("zoomRatio", value);
    }

    public double getZoomRatio() {
        return this.getElement().getProperty("zoomRatio", 0.1);
    }

    public void setMaxRatio(double value) {
        this.getElement().setProperty("maxRatio", value);
    }

    public double getMaxRatio() {
        return this.getElement().getProperty("maxRatio", 1);
    }

    public void setHeight(String value) {
        this.getElement().setProperty("height", value);
    }

    public String getHeight() {
        return this.getElement().getProperty("height");
    }

    public void zoom(double ratio) {
        this.getElement().callJsFunction("zoom", new Serializable[]{Double.valueOf(ratio)});
    }

    public void move(double x, double y) {
        this.getElement().callJsFunction("move", new Serializable[]{Double.valueOf(x), Double.valueOf(y)});
    }

    public void moveTo(double x, double y) {
        this.getElement().callJsFunction("moveTo", new Serializable[]{Double.valueOf(x), Double.valueOf(y)});
    }

    public void reset() {
        this.getElement().callJsFunction("reset", new Serializable[0]);
    }

    public void getContainerData(SerializableConsumer<ContainerData> consumer) {
        this.getElement().executeJs("return this.containerData", new Serializable[0]).then((SerializableConsumer & Serializable)value -> {
            JsonObject data = Json.parse((String)value.toJson());
            ContainerData containerData = new ContainerData();
            containerData.setWidth(data.getNumber("width"));
            containerData.setHeight(data.getNumber("height"));
            containerData.setAspectRatio(data.getNumber("width"));
            consumer.accept((Object)containerData);
        });
    }

    public Registration addReadyListener(ComponentEventListener<ReadyEvent> listener) {
        return this.addListener(ReadyEvent.class, listener);
    }

    public Registration addZoomListener(ComponentEventListener<ZoomEvent> listener) {
        return this.addListener(ZoomEvent.class, listener);
    }

    public Registration addWheelListener(ComponentEventListener<WheelEvent> listener) {
        return this.addListener(WheelEvent.class, listener);
    }

    public Registration addDragStartListener(ComponentEventListener<DragStartEvent> listener) {
        return this.addListener(DragStartEvent.class, listener);
    }

    public Registration addDragListener(ComponentEventListener<DragEvent> listener) {
        return this.addListener(DragEvent.class, listener);
    }

    public Registration addDragEndListener(ComponentEventListener<DragEndEvent> listener) {
        return this.addListener(DragEndEvent.class, listener);
    }

    public Registration addSlideStartListener(ComponentEventListener<SlideStartEvent> listener) {
        return this.addListener(SlideStartEvent.class, listener);
    }

    public Registration addSlideListener(ComponentEventListener<SlideEvent> listener) {
        return this.addListener(SlideEvent.class, listener);
    }

    public Registration addSlideEndListener(ComponentEventListener<SlideEndEvent> listener) {
        return this.addListener(SlideEndEvent.class, listener);
    }

    public Registration addPinchStartListener(ComponentEventListener<PinchStartEvent> listener) {
        return this.addListener(PinchStartEvent.class, listener);
    }

    public Registration addPinchListener(ComponentEventListener<PinchEvent> listener) {
        return this.addListener(PinchEvent.class, listener);
    }

    public Registration addPinchEndListener(ComponentEventListener<PinchEndEvent> listener) {
        return this.addListener(PinchEndEvent.class, listener);
    }

    public Registration addResizeListener(ComponentEventListener<ResizeEvent> listener) {
        return this.addListener(ResizeEvent.class, listener);
    }

    public static enum Direction {
        HORIZONTAL("horizontal"),
        VERTICAL("vertical");

        private String value;

        private Direction(String value) {
            this.value = value;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Fill {
        COVER("cover"),
        CONTAIN("contain"),
        NONE("none");

        private String value;

        private Fill(String value) {
            this.value = value;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }
}

