/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.uploadhelper;

import com.vaadin.flow.component.upload.FinishedEvent;
import com.vaadin.flow.component.upload.Upload;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import lombok.Generated;

public final class FileInfo
implements Serializable {
    private final String name;
    private Upload upload;
    private Boolean complete;
    private Boolean indeterminate;
    private String errorMessage;
    private Integer progress;
    private String status;

    public FileInfo(Upload upload, String name) {
        this.upload = upload;
        this.name = name;
    }

    public FileInfo(FinishedEvent ev) {
        this.upload = (Upload)ev.getSource();
        this.name = ev.getFileName();
    }

    public void update() {
        this.update(false);
    }

    public void create() {
        this.update(true);
    }

    private void update(boolean createIfNotExists) {
        this.upload.getElement().executeJs("var d = this;\nvar i = d.files.findIndex(f=>f.name==$0.name);\nif (i<0) {\n   if ($1) d.files = [... d.files, $0]; else return;\n} else {\n  if (d.files.some((e,j)=>e.name==$0.name && j>i)) d.files=d.files.filter((e,j)=>e.name!=$0.name || j<=i);\n  delete $0.name;\n  d.files[i] = Object.assign(d.files[i], $0);\n}\nd.files = Array.from(d.files);\n", new Serializable[]{this.toJson(), Boolean.valueOf(createIfNotExists)});
    }

    private JsonObject toJson() {
        JsonObject json = Json.createObject();
        json.put("name", this.name);
        if (this.complete != null) {
            json.put("complete", this.complete.booleanValue());
        }
        if (this.indeterminate != null) {
            json.put("indeterminate", this.indeterminate.booleanValue());
        }
        if (this.errorMessage != null) {
            json.put("error", this.errorMessage);
        }
        if (this.progress != null) {
            json.put("progress", (double)this.progress.intValue());
        }
        if (this.status != null) {
            json.put("status", this.status);
        }
        return json;
    }

    public FileInfo complete(Boolean complete) {
        this.complete = complete;
        return this;
    }

    public FileInfo complete() {
        this.complete = true;
        return this;
    }

    public FileInfo indeterminate() {
        return this.indeterminate(true);
    }

    public FileInfo indeterminate(Boolean indeterminate) {
        this.indeterminate = indeterminate;
        return this;
    }

    public FileInfo errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public FileInfo progress(Integer progress) {
        this.progress = progress;
        return this;
    }

    public FileInfo status(String status) {
        this.status = status;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getComplete() {
        return this.complete;
    }

    public Boolean getIndeterminate() {
        return this.indeterminate;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public String getStatus() {
        return this.status;
    }

    @Generated
    Upload getUpload() {
        return this.upload;
    }
}

