/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.uploadhelper;

import com.flowingcode.vaadin.addons.uploadhelper.FileInfo;
import com.flowingcode.vaadin.addons.uploadhelper.NullUpload;
import com.flowingcode.vaadin.addons.uploadhelper.UploadHelperDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.FinishedEvent;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import lombok.Generated;

@PageTitle(value="Playground")
@Route(value="upload-helper/demo", layout=UploadHelperDemoView.class)
public class PlaygroundDemo
extends Div {
    private String fileName;
    private Upload upload;

    public PlaygroundDemo() {
        Component[] componentArray = new Component[1];
        this.upload = new NullUpload();
        componentArray[0] = this.upload;
        this.add(componentArray);
        this.fileName = "test";
        new FileInfo(this.upload, "test").create();
        this.upload.addSucceededListener((ComponentEventListener & Serializable)ev -> {
            this.fileName = ev.getFileName();
            new FileInfo((FinishedEvent)ev).indeterminate().status("Processing...").update();
        });
        Binder binder = new Binder();
        FormLayout formLayout = new FormLayout();
        formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1)});
        this.add(new Component[]{formLayout});
        Checkbox indeterminate = new Checkbox();
        Checkbox complete = new Checkbox();
        TextField status = new TextField();
        TextField errorMessage = new TextField();
        IntegerField progress = new IntegerField();
        progress.setStepButtonsVisible(true);
        formLayout.addFormItem((Component)indeterminate, "Indeterminate");
        formLayout.addFormItem((Component)complete, "Complete");
        formLayout.addFormItem((Component)status, "Status");
        formLayout.addFormItem((Component)errorMessage, "Error Message");
        formLayout.addFormItem((Component)progress, "Progress");
        binder.forField((HasValue)indeterminate).bind(Bean::indeterminate, Bean::indeterminate);
        binder.forField((HasValue)complete).bind(Bean::complete, Bean::complete);
        binder.forField((HasValue)status).bind(Bean::status, Bean::status);
        binder.forField((HasValue)errorMessage).bind(Bean::errorMessage, Bean::errorMessage);
        binder.forField((HasValue)progress).bind(Bean::progress, Bean::progress);
        binder.setBean((Object)new Bean());
        binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> {
            Bean bean = (Bean)binder.getBean();
            FileInfo file = new FileInfo(this.upload, this.fileName);
            file.indeterminate(Boolean.valueOf(bean.indeterminate));
            file.complete(Boolean.valueOf(bean.complete));
            file.status(bean.status);
            file.errorMessage(bean.errorMessage);
            file.progress(Integer.valueOf(bean.progress));
            file.update();
        });
        indeterminate.setValue((Object)true);
    }

    private static class Bean {
        boolean complete;
        boolean indeterminate;
        int progress;
        String status;
        String errorMessage;

        @Generated
        public Bean() {
        }

        @Generated
        public boolean complete() {
            return this.complete;
        }

        @Generated
        public boolean indeterminate() {
            return this.indeterminate;
        }

        @Generated
        public int progress() {
            return this.progress;
        }

        @Generated
        public String status() {
            return this.status;
        }

        @Generated
        public String errorMessage() {
            return this.errorMessage;
        }

        @Generated
        public Bean complete(boolean complete) {
            this.complete = complete;
            return this;
        }

        @Generated
        public Bean indeterminate(boolean indeterminate) {
            this.indeterminate = indeterminate;
            return this;
        }

        @Generated
        public Bean progress(int progress) {
            this.progress = progress;
            return this;
        }

        @Generated
        public Bean status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public Bean errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bean)) {
                return false;
            }
            Bean other = (Bean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.complete() != other.complete()) {
                return false;
            }
            if (this.indeterminate() != other.indeterminate()) {
                return false;
            }
            if (this.progress() != other.progress()) {
                return false;
            }
            String this$status = this.status();
            String other$status = other.status();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$errorMessage = this.errorMessage();
            String other$errorMessage = other.errorMessage();
            return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bean;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.complete() ? 79 : 97);
            result = result * 59 + (this.indeterminate() ? 79 : 97);
            result = result * 59 + this.progress();
            String $status = this.status();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $errorMessage = this.errorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PlaygroundDemo.Bean(complete=" + this.complete() + ", indeterminate=" + this.indeterminate() + ", progress=" + this.progress() + ", status=" + this.status() + ", errorMessage=" + this.errorMessage() + ")";
        }
    }
}

