/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.uploadhelper;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.uploadhelper.FileInfo;
import com.flowingcode.vaadin.addons.uploadhelper.UploadHelperDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.upload.FinishedEvent;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.receivers.MultiFileMemoryBuffer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.NullOutputStream;

@DemoSource
@PageTitle(value="FileInfo Demo")
@Route(value="upload-helper/demo2", layout=UploadHelperDemoView.class)
public class FileInfoDemo
extends Div {
    public FileInfoDemo() {
        this.add(new Component[]{new Div("Simulates progress updates, incrementing from 0% to 100% and updating the UI in real-time.\nAfter reaching 100%, the file is set to \"Please wait...\" with an indeterminate progress state to represent some final processing.\nAfter a 2-second delay, the system randomly determines if the processing succeeded or failed, updating the UI accordingly.")});
        Upload upload = new Upload((Receiver)new MultiFileMemoryBuffer(){

            public OutputStream receiveUpload(String fileName, String MIMEType) {
                super.receiveUpload(fileName, MIMEType);
                return NullOutputStream.INSTANCE;
            }
        });
        this.add(new Component[]{upload});
        ConcurrentHashMap processing = new ConcurrentHashMap();
        upload.addSucceededListener((ComponentEventListener & Serializable)ev -> {
            if (processing.put(ev.getFileName(), true) == null) {
                UI ui = (UI)((Upload)ev.getSource()).getUI().get();
                new Thread(() -> {
                    AtomicInteger progress = new AtomicInteger();
                    while (progress.get() <= 100) {
                        int p = progress.getAndIncrement();
                        ui.access((Command & Serializable)() -> new FileInfo((FinishedEvent)ev).status(String.format("Processing (%s%%)", p)).progress(Integer.valueOf(p)).update());
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    ui.access((Command & Serializable)() -> new FileInfo((FinishedEvent)ev).indeterminate().status("Please wait...").update());
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (Math.random() < 0.5) {
                        ui.access((Command & Serializable)() -> new FileInfo((FinishedEvent)ev).complete().update());
                    } else {
                        ui.access((Command & Serializable)() -> new FileInfo((FinishedEvent)ev).errorMessage("Random failure").update());
                    }
                    processing.remove(ev.getFileName());
                }).start();
            }
        });
    }
}

